/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.zones;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.function.Throwing;
import de.intarsys.tools.zones.IZone;
import de.intarsys.tools.zones.Zone;
import de.intarsys.tools.zones.ZoneSpec;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class StandardZone
implements IZone {
    private final IAttributeSupport scope;
    private final IZone parent;
    private final String name;
    private final Consumer<IZone> onEnter;
    private final Consumer<IZone> onLeave;

    public StandardZone(IZone parent, ZoneSpec spec) {
        this((String)(spec.getName() == null ? parent.getName() + "'" : spec.getName()), parent, spec.getAttributeSupport() == null ? new AttributeMap() : spec.getAttributeSupport(), spec.getOnEnter(), spec.getOnLeave());
    }

    protected StandardZone(String name, IZone parent) {
        this(name, parent, new AttributeMap());
    }

    protected StandardZone(String name, IZone parent, IAttributeSupport scope) {
        this.name = name;
        this.parent = parent;
        this.scope = scope;
        this.onEnter = null;
        this.onLeave = null;
    }

    protected StandardZone(String name, IZone parent, IAttributeSupport scope, Consumer<IZone> onBefore, Consumer<IZone> onAfter) {
        this.name = name;
        this.parent = parent;
        this.scope = scope;
        this.onEnter = onBefore;
        this.onLeave = onAfter;
    }

    protected <R> Callable<R> createCallable(final Callable<R> functionalInterface) {
        return new Callable<R>(){

            @Override
            public R call() throws Exception {
                try {
                    StandardZone.this.onBefore();
                    Object v = functionalInterface.call();
                    return v;
                }
                finally {
                    StandardZone.this.onFinally();
                }
            }
        };
    }

    protected <T> Consumer<T> createConsumer(final Consumer<T> functionalInterface) {
        return new Consumer<T>(){

            @Override
            public void accept(T value) {
                try {
                    StandardZone.this.onBefore();
                    functionalInterface.accept(value);
                }
                finally {
                    StandardZone.this.onFinally();
                }
            }
        };
    }

    protected <T, E extends Exception> Throwing.Consumer<T> createConsumer(final Throwing.Specific.Consumer<T, E> functionalInterface) {
        return new Throwing.Consumer<T>(){

            @Override
            public void accept(T value) throws Exception {
                try {
                    StandardZone.this.onBefore();
                    functionalInterface.accept(value);
                }
                finally {
                    StandardZone.this.onFinally();
                }
            }
        };
    }

    protected <T, R> Function<T, R> createFunction(final Function<T, R> functionalInterface) {
        return new Function<T, R>(){

            @Override
            public R apply(T value) {
                try {
                    StandardZone.this.onBefore();
                    Object r = functionalInterface.apply(value);
                    return r;
                }
                finally {
                    StandardZone.this.onFinally();
                }
            }
        };
    }

    protected <T, R, E extends Exception> Throwing.Specific.Function<T, R, E> createFunction(final Throwing.Specific.Function<T, R, E> functionalInterface) {
        return new Throwing.Specific.Function<T, R, E>(){

            @Override
            public R apply(T value) throws Exception {
                try {
                    StandardZone.this.onBefore();
                    Object r = functionalInterface.apply(value);
                    return r;
                }
                finally {
                    StandardZone.this.onFinally();
                }
            }
        };
    }

    protected Runnable createRunnable(final Runnable functionalInterface) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    StandardZone.this.onBefore();
                    functionalInterface.run();
                }
                finally {
                    StandardZone.this.onFinally();
                }
            }
        };
    }

    protected <R> Supplier<R> createSupplier(final Supplier<R> functionalInterface) {
        return new Supplier<R>(){

            @Override
            public R get() {
                try {
                    StandardZone.this.onBefore();
                    Object t = functionalInterface.get();
                    return t;
                }
                finally {
                    StandardZone.this.onFinally();
                }
            }
        };
    }

    protected <R, E extends Exception> Throwing.Supplier<R> createSupplier(final Throwing.Specific.Supplier<R, E> functionalInterface) {
        return new Throwing.Supplier<R>(){

            @Override
            public R get() throws Exception {
                try {
                    StandardZone.this.onBefore();
                    Object t = functionalInterface.get();
                    return t;
                }
                finally {
                    StandardZone.this.onFinally();
                }
            }
        };
    }

    @Override
    public void enter() {
        Zone.push(this);
        if (this.onEnter != null) {
            this.onEnter.accept(this);
        }
    }

    @Override
    public IZone fork(ZoneSpec spec) {
        return new StandardZone(this, spec);
    }

    @Override
    public Object getAttribute(Object key) {
        Object result = this.scope.getAttribute(key);
        if (result != null) {
            return result;
        }
        if (this.getParent() != null) {
            return this.getParent().getAttribute(key);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IZone getParent() {
        return this.parent;
    }

    @Override
    public void leave() {
        if (Zone.peek() != this) {
            throw new InvalidRequestException("zone " + this.getName() + " not active");
        }
        if (this.onLeave != null) {
            this.onLeave.accept(this);
        }
        Zone.pop();
    }

    protected void onBefore() {
        this.enter();
    }

    protected void onFinally() {
        this.leave();
    }

    @Override
    public Object removeAttribute(Object key) {
        return this.scope.removeAttribute(key);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.scope.setAttribute(key, value);
    }

    public String toString() {
        return "zone '" + this.getName() + "'";
    }

    @Override
    public Callable wrap(Callable functionalInterface) {
        return this.createCallable(functionalInterface);
    }

    @Override
    public Consumer wrap(Consumer functionalInterface) {
        return this.createConsumer(functionalInterface);
    }

    @Override
    public Function wrap(Function functionalInterface) {
        return this.createFunction(functionalInterface);
    }

    @Override
    public Runnable wrap(Runnable functionalInterface) {
        return this.createRunnable(functionalInterface);
    }

    @Override
    public Supplier wrap(Supplier functionalInterface) {
        return this.createSupplier(functionalInterface);
    }

    @Override
    public Throwing.Specific.Consumer wrap(Throwing.Specific.Consumer functionalInterface) {
        return this.createConsumer(functionalInterface);
    }

    @Override
    public Throwing.Specific.Function wrap(Throwing.Specific.Function functionalInterface) {
        return this.createFunction(functionalInterface);
    }

    @Override
    public Throwing.Specific.Supplier wrap(Throwing.Specific.Supplier functionalInterface) {
        return this.createSupplier(functionalInterface);
    }
}

