/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.core;

import de.intarsys.security.virtualkeystore.core.IResolver;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStore;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreEntry;
import de.intarsys.tools.environment.file.IFileEnvironment;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class CommonResolver
implements IResolver {
    @XmlTransient
    private IVirtualKeyStoreEntry parent;
    @XmlElement(name="path")
    private String path;
    @XmlTransient
    private ILocator locator;

    public static File resolveFile(IVirtualKeyStore keystore, String path) {
        File baseDir;
        File file = new File(path);
        if (!file.isAbsolute() && keystore instanceof IFileEnvironment && (baseDir = ((IFileEnvironment)keystore).getBaseDir()) != null) {
            file = new File(baseDir, path);
        }
        return file;
    }

    protected CommonResolver() {
    }

    protected CommonResolver(ILocator locator) {
        this();
        this.setLocator(locator);
        this.setPath(locator.getPath());
    }

    protected CommonResolver(String path) {
        this();
        this.setPath(path);
    }

    public ILocator getLocator() {
        if (this.locator == null && this.getPath() != null) {
            this.locator = new FileLocator(this.getResolvedFile());
        }
        return this.locator;
    }

    @Override
    public IVirtualKeyStoreEntry getParent() {
        return this.parent;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    protected File getResolvedFile() {
        if (this.getPath() == null) {
            return null;
        }
        if (this.getParent() == null) {
            return new File(this.getPath());
        }
        return CommonResolver.resolveFile(this.getParent().getStore(), this.path);
    }

    public void setLocator(ILocator locator) {
        this.locator = locator;
    }

    @Override
    public void setParent(IVirtualKeyStoreEntry parent) {
        this.parent = parent;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public ILocator toLocator() {
        return this.getLocator();
    }

    @Override
    public String toURI() {
        return this.getResolvedFile().toURI().toString();
    }
}

