/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.core;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.virtualkeystore.core.CommonResolver;
import de.intarsys.security.virtualkeystore.core.ICertificateResolver;
import de.intarsys.security.virtualkeystore.core.IPrivateKeyResolver;
import de.intarsys.security.virtualkeystore.core.IResolver;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;

public abstract class DelegatingResolver
extends CommonResolver
implements ICertificateResolver,
IPrivateKeyResolver {
    private IResolver resolver;

    protected DelegatingResolver() {
    }

    protected DelegatingResolver(ILocator locator) {
        super(locator);
    }

    protected DelegatingResolver(String path) {
        super(path);
    }

    protected abstract IResolver createDelegateResolver() throws IOException, GeneralSecurityException;

    @Override
    public IX509Certificate getCertificate() throws IOException, GeneralSecurityException {
        IResolver resolver = this.getDelegateResolver();
        if (resolver instanceof ICertificateResolver) {
            return ((ICertificateResolver)resolver).getCertificate();
        }
        return null;
    }

    protected IResolver getDelegateResolver() throws IOException, GeneralSecurityException {
        if (this.resolver == null) {
            this.resolver = this.createDelegateResolver();
        }
        return this.resolver;
    }

    @Override
    public PrivateKey getPrivateKey(Secret password) throws IOException, GeneralSecurityException {
        IResolver resolver = this.getDelegateResolver();
        if (resolver instanceof IPrivateKeyResolver) {
            return ((IPrivateKeyResolver)resolver).getPrivateKey(password);
        }
        return null;
    }

    @Override
    public String toURI() {
        return this.getPath();
    }
}

