/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.core;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CommonCertificateProvider;
import de.intarsys.security.certificate.common.CommonX509Certificate;
import de.intarsys.security.certificate.filter.CertificateFilterIterator;
import de.intarsys.security.certificate.filter.IServiceTypeSelector;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.privatekey.IPasswordProtectionSupport;
import de.intarsys.security.privatekey.IPrivateKeyProvider;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStore;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreEntry;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreIDEntry;
import de.intarsys.security.virtualkeystore.core.PACKAGE;
import de.intarsys.security.virtualkeystore.core.VirtualKeyStore;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.collection.FilterIterator;
import de.intarsys.tools.collection.NullFilterIterator;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.presentation.IPresentationSupport;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualKeyStorePlainCertificateProvider
extends CommonCertificateProvider
implements IPresentationSupport,
IPrivateKeyProvider,
IPasswordProtectionSupport {
    private static final Attribute ATTR_ALIAS = new Attribute("alias");
    private static final Logger Log = LoggerFactory.getLogger(VirtualKeyStorePlainCertificateProvider.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final IVirtualKeyStore keyStore;
    private final INotificationListener listenVirtualKeyStoreChanged = new INotificationListener(){

        public void handleEvent(Event event) {
            VirtualKeyStorePlainCertificateProvider.this.triggerChanged();
        }
    };

    public VirtualKeyStorePlainCertificateProvider() {
        this(VirtualKeyStore.get());
    }

    public VirtualKeyStorePlainCertificateProvider(IVirtualKeyStore keyStore) {
        this.keyStore = keyStore;
        this.addListeners();
    }

    protected void addListeners() {
        if (this.keyStore instanceof INotificationSupport) {
            ((INotificationSupport)this.keyStore).addNotificationListener(AttributeChangedEvent.ID, this.listenVirtualKeyStoreChanged);
        }
    }

    protected Iterator<IVirtualKeyStoreEntry> entryIterator(final IX509CertificateFilter filter) {
        return new FilterIterator<IVirtualKeyStoreEntry>(this.keyStore.entryIterator()){

            protected boolean accept(IVirtualKeyStoreEntry object) {
                if (!(filter instanceof IX509CertificateSelector)) {
                    return true;
                }
                IX509CertificateSelector selector = (IX509CertificateSelector)filter;
                if (selector.hasPrivateKey() != null && selector.hasPrivateKey().booleanValue() && !(object instanceof IVirtualKeyStoreIDEntry)) {
                    return false;
                }
                IServiceTypeSelector serviceTypeSelector = selector.getServiceTypeSelector();
                return serviceTypeSelector == null || serviceTypeSelector.isTrustedOnly() == object.isTrusted();
            }
        };
    }

    protected IVirtualKeyStoreEntry getEntry(String alias) {
        if (alias == null) {
            return null;
        }
        return this.keyStore.getEntry(alias);
    }

    public String getLabel() {
        return Msg.getString("VirtualKeyStoreCertificateProvider.Label", new Object[0]);
    }

    public PrivateKey getPrivateKey(IX509PublicKeyCertificate certificate, IPasswordProvider passwordProvider) throws UnrecoverableKeyException, IOException {
        String alias = (String)certificate.getAttribute((Object)ATTR_ALIAS);
        IVirtualKeyStoreIDEntry entry = (IVirtualKeyStoreIDEntry)this.getEntry(alias);
        try {
            Secret password = passwordProvider.getPassword();
            return entry.getPrivateKey(password);
        }
        catch (UnrecoverableKeyException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            UnrecoverableKeyException ex = new UnrecoverableKeyException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public String getProviderName() {
        return "BC";
    }

    public boolean hasPrivateKey(IX509PublicKeyCertificate certificate) {
        String alias;
        return certificate instanceof IAttributeSupport && this.getEntry(alias = (String)certificate.getAttribute((Object)ATTR_ALIAS)) instanceof IVirtualKeyStoreIDEntry;
    }

    public boolean isPrivateKeyPasswordProtected(IX509PublicKeyCertificate certificate) {
        return true;
    }

    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        ConversionIterator<IVirtualKeyStoreEntry, IX509Certificate> certificates = new ConversionIterator<IVirtualKeyStoreEntry, IX509Certificate>(this.entryIterator(filter)){

            protected IX509Certificate createTargetObject(IVirtualKeyStoreEntry sourceObject) {
                try {
                    IX509Certificate certificate = sourceObject.getCertificate();
                    if (certificate != null) {
                        if (certificate instanceof CommonX509Certificate) {
                            ((CommonX509Certificate)certificate).setCertificateProvider((ICertificateProvider)VirtualKeyStorePlainCertificateProvider.this);
                        }
                        certificate.setAttribute((Object)ATTR_ALIAS, (Object)sourceObject.getAlias());
                    }
                    return certificate;
                }
                catch (Exception e) {
                    Log.info(e.getMessage());
                    Log.trace(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        };
        certificates = new NullFilterIterator((Iterator)certificates);
        return filter == null ? certificates : new CertificateFilterIterator((Iterator)certificates, filter);
    }
}

