/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.resolver;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.virtualkeystore.core.CommonResolver;
import de.intarsys.security.virtualkeystore.core.ICertificateResolver;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;

public class CERResolver
extends CommonResolver
implements ICertificateResolver {
    @XmlTransient
    private IX509Certificate certificate;

    public CERResolver() {
    }

    public CERResolver(ILocator locator) {
        super(locator);
    }

    public CERResolver(String path) {
        super(path);
    }

    @Override
    public synchronized IX509Certificate getCertificate() throws IOException, GeneralSecurityException {
        if (this.certificate == null) {
            this.certificate = this.loadCertificate();
        }
        return this.certificate;
    }

    protected IX509Certificate loadCertificate() throws IOException, GeneralSecurityException {
        InputStream is = null;
        try {
            is = this.getLocator().getInputStream();
            IX509Certificate iX509Certificate = X509CertificateFactory.get().createCertificate(is);
            return iX509Certificate;
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }
}

