/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.resolver;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.keystore.outlet.IKeyStoreOutlet;
import de.intarsys.security.keystore.outlet.KeyStoreOutlet;
import de.intarsys.security.virtualkeystore.core.ICertificateResolver;
import de.intarsys.security.virtualkeystore.core.IPrivateKeyResolver;
import de.intarsys.security.virtualkeystore.resolver.AliasBasedResolver;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.security.KeyStoreTools;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class JKSResolver
extends AliasBasedResolver
implements ICertificateResolver,
IPrivateKeyResolver {
    @XmlTransient
    private IX509Certificate certificate;

    public JKSResolver() {
    }

    public JKSResolver(ILocator locator, String alias) {
        super(locator);
        this.setAlias(alias);
    }

    public JKSResolver(String path, String alias) {
        super(path);
        this.setAlias(alias);
    }

    @Override
    public synchronized IX509Certificate getCertificate() throws IOException, GeneralSecurityException {
        if (this.certificate == null) {
            this.certificate = this.loadCertificate();
        }
        return this.certificate;
    }

    protected KeyStore getKeyStore() throws GeneralSecurityException, IOException {
        KeyStore ks = null;
        IKeyStoreOutlet outlet = KeyStoreOutlet.get();
        if (outlet != null) {
            ks = outlet.lookupKeyStore(this.getResolvedFile(), "JKS");
        }
        if (ks == null) {
            ks = KeyStoreTools.createJavaKeyStore((ILocator)this.getLocator(), (String)"JKS", (char[])null);
        }
        return ks;
    }

    @Override
    public PrivateKey getPrivateKey(Secret password) throws IOException, GeneralSecurityException {
        KeyStore ks = this.getKeyStore();
        if (ks == null) {
            return null;
        }
        return (PrivateKey)ks.getKey(this.getAlias(), CryptoTools.getChars((Secret)password));
    }

    protected IX509Certificate loadCertificate() throws GeneralSecurityException, IOException {
        KeyStore ks = this.getKeyStore();
        if (ks == null) {
            return null;
        }
        X509Certificate jdkCert = (X509Certificate)ks.getCertificate(this.getAlias());
        return CertificateTools.wrapJavaCert((X509Certificate)jdkCert);
    }
}

