/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.resolver;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.keystore.outlet.IKeyStoreOutlet;
import de.intarsys.security.keystore.outlet.KeyStoreOutlet;
import de.intarsys.security.virtualkeystore.core.CommonResolver;
import de.intarsys.security.virtualkeystore.core.ICertificateResolver;
import de.intarsys.security.virtualkeystore.core.IPrivateKeyResolver;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.security.KeyStoreTools;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class PEMResolver
extends CommonResolver
implements ICertificateResolver,
IPrivateKeyResolver {
    @XmlTransient
    private IX509Certificate certificate;

    public PEMResolver() {
    }

    public PEMResolver(ILocator locator) {
        super(locator);
    }

    public PEMResolver(String path) {
        super(path);
    }

    @Override
    public synchronized IX509Certificate getCertificate() throws IOException, GeneralSecurityException {
        if (this.certificate == null) {
            this.certificate = this.loadCertificate();
        }
        return this.certificate;
    }

    protected KeyStore getKeyStore() throws GeneralSecurityException, IOException {
        KeyStore ks = null;
        IKeyStoreOutlet outlet = KeyStoreOutlet.get();
        if (outlet != null) {
            ks = outlet.lookupKeyStore(this.getResolvedFile(), "PEM");
        }
        if (ks == null) {
            ks = KeyStoreTools.createJavaKeyStore((ILocator)this.getLocator(), (String)"PEM", (char[])null);
        }
        return ks;
    }

    @Override
    public PrivateKey getPrivateKey(Secret password) throws IOException, GeneralSecurityException {
        KeyStore keystore = this.getKeyStore();
        if (keystore == null) {
            return null;
        }
        Enumeration<String> e = keystore.aliases();
        if (e.hasMoreElements()) {
            String alias = e.nextElement();
            return (PrivateKey)keystore.getKey(alias, CryptoTools.getChars((Secret)password));
        }
        return null;
    }

    protected IX509Certificate loadCertificate() throws GeneralSecurityException, IOException {
        KeyStore keystore = this.getKeyStore();
        if (keystore == null) {
            return null;
        }
        Enumeration<String> e = keystore.aliases();
        if (e.hasMoreElements()) {
            String alias = e.nextElement();
            X509Certificate jdkCert = (X509Certificate)keystore.getCertificate(alias);
            return CertificateTools.wrapJavaCert((X509Certificate)jdkCert);
        }
        return null;
    }
}

