/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.resolver;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFacade;
import de.intarsys.security.privatekey.PrivateKeyTools;
import de.intarsys.security.virtualkeystore.core.ICertificateResolver;
import de.intarsys.security.virtualkeystore.core.IPrivateKeyResolver;
import de.intarsys.security.virtualkeystore.resolver.AliasBasedResolver;
import de.intarsys.tools.authenticate.ConstantPasswordProvider;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.locator.ILocator;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.util.Iterator;

public class PKCS12Resolver
extends AliasBasedResolver
implements ICertificateResolver,
IPrivateKeyResolver {
    @XmlTransient
    private IX509Certificate certificate;
    @XmlTransient
    private Secret password;

    public PKCS12Resolver() {
    }

    public PKCS12Resolver(ILocator locator) {
        super(locator);
    }

    public PKCS12Resolver(String path) {
        super(path);
    }

    @Override
    public synchronized IX509Certificate getCertificate() throws IOException, GeneralSecurityException {
        if (this.certificate == null) {
            this.certificate = this.loadCertificate();
        }
        return this.certificate;
    }

    public Secret getPassword() {
        return this.password;
    }

    @Override
    public PrivateKey getPrivateKey(Secret password) throws IOException, GeneralSecurityException {
        return PrivateKeyTools.getPrivateKey((IX509PublicKeyCertificate)((IX509PublicKeyCertificate)this.loadKeyEntity(password)), (IPasswordProvider)new ConstantPasswordProvider(password));
    }

    protected IX509Certificate loadCertificate() throws GeneralSecurityException, IOException {
        KeyStoreFacade ksFacade = KeyStoreFacade.createPKCS12((ILocator)this.getLocator());
        ksFacade.load(this.getPassword());
        IX509Certificate result = null;
        if (this.getAlias() == null) {
            Iterator i = ksFacade.getCertificateEntities();
            if (i.hasNext()) {
                result = (IX509Certificate)i.next();
            }
        } else {
            result = ksFacade.getCertificate(this.getAlias());
        }
        return result;
    }

    protected IX509Certificate loadKeyEntity(Secret password) throws IOException, GeneralSecurityException {
        KeyStoreFacade ksFacade = KeyStoreFacade.createPKCS12((ILocator)this.getLocator());
        if (password == null) {
            password = this.getPassword();
        }
        try {
            ksFacade.load(password);
        }
        catch (IOException e) {
            throw new UnrecoverableKeyException();
        }
        IX509PublicKeyCertificate result = null;
        if (this.getAlias() == null) {
            Iterator i = ksFacade.getKeyEntities();
            if (i.hasNext()) {
                result = (IX509Certificate)i.next();
            }
        } else {
            result = ksFacade.getKey(this.getAlias());
        }
        return result;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }
}

