/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.resolver;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.keystore.outlet.IKeyStoreOutlet;
import de.intarsys.security.keystore.outlet.KeyStoreOutlet;
import de.intarsys.security.virtualkeystore.core.ICertificateResolver;
import de.intarsys.security.virtualkeystore.resolver.AliasBasedResolver;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;

public class PKCS7Resolver
extends AliasBasedResolver
implements ICertificateResolver {
    @XmlTransient
    private IX509Certificate certificate;

    public PKCS7Resolver() {
    }

    public PKCS7Resolver(ILocator locator, String alias) {
        super(locator);
        this.setAlias(alias);
    }

    public PKCS7Resolver(String path, String alias) {
        super(path);
        this.setAlias(alias);
    }

    @Override
    public IX509Certificate getCertificate() throws IOException, GeneralSecurityException {
        if (this.certificate == null) {
            this.certificate = this.loadCertificate();
        }
        return this.certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IX509Certificate loadCertificate() throws GeneralSecurityException, IOException {
        KeyStore ks = null;
        IKeyStoreOutlet outlet = KeyStoreOutlet.get();
        if (outlet != null) {
            ks = outlet.lookupKeyStore(this.getResolvedFile(), "PKCS#7");
        }
        if (ks == null) {
            ks = KeyStore.getInstance("PKCS#7", "intarsys");
            InputStream fIn = this.getLocator().getInputStream();
            try {
                ks.load(fIn, null);
            }
            finally {
                StreamTools.close((Closeable)fIn);
            }
        }
        X509Certificate jdkCert = (X509Certificate)ks.getCertificate(this.getAlias());
        return CertificateTools.wrapJavaCert((X509Certificate)jdkCert);
    }
}

