/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.httptimestamp.app;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.rfc3161.MessageImprint;
import de.intarsys.asn1.rfc3161.TimeStampReq;
import de.intarsys.asn1.rfc3161.TimeStampResp;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.timestamp.CommonTimestampCreator;
import de.intarsys.security.app.timestamp.ITimestampRequest;
import de.intarsys.security.app.timestamp.ITimestampResponse;
import de.intarsys.security.app.timestamp.PlainTimestampRequest;
import de.intarsys.security.app.timestamp.PlainTimestampResponse;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.IdCertificateProvider;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.httptimestamp.app.PACKAGE;
import de.intarsys.security.device.httptimestamp.device.HttpTimestampDevice;
import de.intarsys.security.environment.SecurityEnvironment;
import de.intarsys.security.method.cms.timestamp.TimestampToken;
import de.intarsys.security.ssl.CertificateBasedKeyManagerProvider;
import de.intarsys.security.timestamp.ITimestampInfo;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.security.tsa.rfc3161.RFC3161TimestampRequest;
import de.intarsys.security.tsa.rfc3161.RFC3161TimestampResponse;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.date.DateTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.ssl.IConfigurableSslContextProvider;
import de.intarsys.tools.ssl.IKeyManagerProvider;
import de.intarsys.tools.ssl.SslContextProvider;
import de.intarsys.tools.ssl.SslTools;
import de.intarsys.tools.stream.StreamTools;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Base64;
import java.util.Date;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTimestampCreator
extends CommonTimestampCreator {
    private static final Logger Log = LoggerFactory.getLogger(HttpTimestampCreator.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL);
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public HttpTimestampCreator(HttpTimestampDevice device) {
        super((CommonDevice)device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] basicPerformRequest(byte[] requestData, String url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
        if (con instanceof HttpsURLConnection) {
            this.configureSSLConnection((HttpsURLConnection)con);
        }
        con.setRequestProperty("Content-Type", "application/timestamp-query");
        con.setRequestProperty("Accept", "application/timestamp-reply");
        con.setConnectTimeout(10000);
        con.setReadTimeout(10000);
        this.configureConnection(con);
        con.setDoInput(true);
        con.setDoOutput(true);
        DataOutputStream dataOut = null;
        try {
            OutputStream out = con.getOutputStream();
            dataOut = new DataOutputStream(new BufferedOutputStream(out));
            dataOut.write(requestData);
        }
        catch (Throwable throwable) {
            StreamTools.close(dataOut);
            throw throwable;
        }
        StreamTools.close((Closeable)dataOut);
        int responseCode = con.getResponseCode();
        Log.debug("timestamp server HTTP response " + responseCode);
        if (responseCode != 200) {
            String responseMsg = this.getErrorMessage(con);
            throw new IOException(responseMsg);
        }
        InputStream in = null;
        byte[] responseData = null;
        try {
            in = (InputStream)con.getContent();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int i = in.read();
            while (i != -1) {
                os.write(i);
                i = in.read();
            }
            responseData = os.toByteArray();
        }
        finally {
            StreamTools.close((Closeable)in);
        }
        return responseData;
    }

    protected void configureConnection(HttpURLConnection con) {
        Log.debug("timestamp basic authentication for " + this.getDevice().getUser());
        if (this.getDevice().getUser() == null || this.getDevice().getPassword() == null) {
            return;
        }
        String s = this.getDevice().getUser() + ":" + this.getDevice().getPassword();
        String encoded = Base64.getEncoder().encodeToString(s.getBytes());
        con.setRequestProperty("Authorization", "Basic " + encoded);
    }

    protected void configureSSLConnection(HttpsURLConnection con) throws IOException {
        SSLContext sslContext = this.createSslContext();
        con.setSSLSocketFactory(sslContext.getSocketFactory());
        if (this.getDevice().getHostnameVerifier() != null) {
            con.setHostnameVerifier(this.getDevice().getHostnameVerifier());
        }
    }

    protected SSLContext createSslContext() throws IOException {
        try {
            ICertificateProvider certificateProvider = IdCertificateProvider.get();
            IX509CertificateFilter certificateSelector = this.getDevice().getTlsClientCertificateSelector();
            if (certificateSelector == null) {
                return SslTools.createSslContextDefault();
            }
            IConfigurableSslContextProvider sslContextProvider = SslContextProvider.get().createProvider();
            CertificateBasedKeyManagerProvider keyManagerProvider = new CertificateBasedKeyManagerProvider();
            keyManagerProvider.setCertificateProvider(certificateProvider);
            keyManagerProvider.setKeyPasswordProvider(cert -> this.getCertificatePassword((IX509PublicKeyCertificate)cert));
            keyManagerProvider.setSelector((Object)certificateSelector);
            sslContextProvider.setKeyManagerProvider((IKeyManagerProvider)keyManagerProvider);
            return sslContextProvider.createSslContext();
        }
        catch (GeneralSecurityException e) {
            throw new IOException("error creating SSL context", e);
        }
    }

    public ITimestampResponse createTimestamp(ITimestampRequest request) throws SecurityApplicationException {
        if ("RFC3161".equals(request.getFormat())) {
            return this.createTimestamp((RFC3161TimestampRequest)request);
        }
        if ("plain".equals(request.getFormat())) {
            return this.createTimestamp((PlainTimestampRequest)request);
        }
        throw new SecurityApplicationException("Unsupported request format: " + request.getFormat());
    }

    protected PlainTimestampResponse createTimestamp(PlainTimestampRequest request) throws SecurityApplicationException {
        PKIStatusInfo statusInfo;
        try {
            MessageImprint messageImprint = (MessageImprint)MessageImprint.FACTORY.createNew();
            String algorithmOid = DigestAlgorithm.lookupOID((String)request.getDigest().getAlgorithmName());
            messageImprint.setHashAlgorithm(AlgorithmIdentifier.create((String)algorithmOid));
            messageImprint.setHashedMessage(request.getDigest().getBytes());
            TimeStampReq timeStampReq = (TimeStampReq)TimeStampReq.FACTORY.createNew();
            timeStampReq.setMessageImprint(messageImprint);
            timeStampReq.setCertReq(true);
            BigInteger nonce = BigInteger.valueOf((long)(Math.random() * 1000000.0));
            timeStampReq.setNonce(nonce);
            Log.info(this.getDevice() + " request timestamp");
            byte[] requestData = timeStampReq.getDEREncoded();
            byte[] responseData = this.performRequest(requestData, this.getDevice().getUrl());
            Log.info(this.getDevice() + " request timestamp");
            TimeStampResp response = (TimeStampResp)TimeStampResp.FACTORY.create((ASN1Encodable)ASN1Tools.create((byte[])responseData));
            statusInfo = response.getStatus();
            Log.debug(this.getDevice() + " PKI status: " + statusInfo.getStatus().intValue());
            if (statusInfo.getStatus().intValue() == 0) {
                byte[] bytes = response.getTimeStampToken().toASN1Primitive().getEncoded("DER");
                CMS cms = (CMS)ASN1BasedTools.create((ASN1Based.Factory)CMS.FACTORY, (byte[])bytes);
                ITimestampToken ts = TimestampToken.create((CMS)cms);
                this.logTimestamp(ts);
                BigInteger responseNonce = ts.getTimestampInfo().getNonce();
                if (!nonce.equals(responseNonce)) {
                    throw new SecurityApplicationException("Invalid response nonce: " + responseNonce + " (request nonce: " + nonce + ")");
                }
                return new PlainTimestampResponse(ts);
            }
        }
        catch (IOException e) {
            throw new SecurityApplicationException(e.getMessage(), (Throwable)e);
        }
        PKIFreeText statusString = statusInfo.getStatusString();
        StringBuilder sb = new StringBuilder();
        if (statusString == null || statusString.size() == 0) {
            sb.append("???");
        } else {
            for (int i = 0; i < statusString.size(); ++i) {
                DERUTF8String c = statusString.getStringAt(i);
                sb.append(c.getString());
                if (i >= statusString.size() - 1) continue;
                sb.append(" / ");
            }
        }
        throw new SecurityApplicationException(statusInfo.getStatus().intValue() + ": " + sb.toString());
    }

    protected RFC3161TimestampResponse createTimestamp(RFC3161TimestampRequest request) throws SecurityApplicationException {
        byte[] response;
        Log.info(this.getDevice() + " request timestamp");
        try {
            response = this.performRequest(request.getEncoded(), this.getDevice().getUrl());
        }
        catch (IOException e) {
            throw new SecurityApplicationException(e.getMessage(), (Throwable)e);
        }
        return new RFC3161TimestampResponse(response);
    }

    protected Secret getCertificatePassword(IX509PublicKeyCertificate certificate) {
        String id = CertificateTools.getUniqueIdentifier((IX509PublicKeyCertificate)certificate);
        Secret password = SecurityEnvironment.get().getSecret(id);
        if (password == null) {
            password = this.getPasswordProvider().getPassword();
        }
        return password;
    }

    public HttpTimestampDevice getDevice() {
        return (HttpTimestampDevice)super.getDevice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getErrorMessage(HttpURLConnection con) {
        InputStream in;
        Object responseMsg = null;
        try {
            responseMsg = con.getResponseMessage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (responseMsg == null) {
            responseMsg = "";
        }
        if ((in = con.getErrorStream()) == null) {
            return responseMsg;
        }
        StringWriter w = new StringWriter();
        try {
            InputStreamReader r = new InputStreamReader(in);
            int i = r.read();
            while (i != -1) {
                w.write(i);
                i = r.read();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            StreamTools.close((Closeable)in);
        }
        responseMsg = (String)responseMsg + "(" + w.toString() + ")";
        return responseMsg;
    }

    protected void logTimestamp(ITimestampToken timestamp) {
        ITimestampInfo tsInfo;
        try {
            tsInfo = timestamp.getTimestampInfo();
        }
        catch (IOException e) {
            Log.warn(this.getDevice() + " " + e.getMessage(), (Throwable)e);
            return;
        }
        Date date = tsInfo.getGenTime();
        Log.info(this.getDevice() + " timestamp time: " + FORMATTER.format(DateTools.toZonedDateTime((Date)date)));
        Log.info(this.getDevice() + " timestamp serial number: " + tsInfo.getSerialNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] performRequest(byte[] requestData, String url) throws IOException {
        if (this.getDevice().isSynchronizeRequests()) {
            Object object = this.getDevice().getRequestLock();
            synchronized (object) {
                return this.basicPerformRequest(requestData, url);
            }
        }
        return this.basicPerformRequest(requestData, url);
    }
}

