/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.httptimestamp.device;

import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.httptimestamp.device.HttpTimestampDeviceProvider;
import de.intarsys.security.device.httptimestamp.device.PACKAGE;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.IFactorySupport;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.infoset.IElementSerializationHandler;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import javax.net.ssl.HostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FactoredBy(factory=HttpTimestampDeviceProvider.class)
public class HttpTimestampDevice
extends CommonDevice<HttpTimestampDeviceProvider> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(HttpTimestampDevice.class);
    public static final String TYPE_DEFAULT = "default";
    public static final String TYPE_BASIC_AUTH = "basic";
    public static final String TYPE_TLS_CLIENT = "tlsClient";
    private static final String TYPE_BASIC_AUTH_DEPRECATED = "httpAuth";
    private String user;
    private String password;
    private IX509CertificateFilter tlsClientCertificateSelector;
    private String url;
    private HostnameVerifier hostnameVerifier;
    private int connectTimeout = 5000;
    private int readTimeout = 60000;
    private boolean synchronizeRequests;
    private final Object requestLock = new Object();

    protected HttpTimestampDevice(HttpTimestampDeviceProvider provider, String id) {
        super((CommonDeviceProvider)provider, id);
    }

    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.setUrl(element.attributeValue("url", null));
        this.setConnectTimeout(ElementTools.getInt((IElement)element, (String)"connectTimeout", (int)this.getConnectTimeout()));
        this.setReadTimeout(ElementTools.getInt((IElement)element, (String)"readTimeout", (int)this.getReadTimeout()));
        this.setSynchronizeRequests(ElementTools.getBoolean((IElement)element, (String)"synchronizeRequests", (boolean)this.isSynchronizeRequests()));
        String type = TYPE_DEFAULT;
        IElement eAuth = element.element("auth");
        if (eAuth != null) {
            switch (type = eAuth.attributeValue("type", type)) {
                case "basic": 
                case "httpAuth": {
                    this.setUser(eAuth.attributeValue("user", null));
                    this.setPassword(eAuth.attributeValue("password", null));
                    break;
                }
                case "tlsClient": {
                    IElement certificateFilterElement = element.element("tlsClientCertificate");
                    if (certificateFilterElement == null) break;
                    try {
                        this.setTlsClientCertificateSelector((IX509CertificateFilter)ElementTools.createObject((IElement)certificateFilterElement, IX509CertificateFilter.class, (Object)((Object)this), (IArgs)Args.create()));
                        break;
                    }
                    catch (ObjectCreationException e) {
                        throw new ConfigurationException((Throwable)e);
                    }
                }
            }
        }
        try {
            this.setHostnameVerifier((HostnameVerifier)ElementTools.createObject((IElement)element.element("hostnameVerifier"), HostnameVerifier.class, (Object)((Object)this), (IArgs)Args.create()));
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public String getAuthType() {
        if (this.getUser() != null && this.getPassword() != null) {
            return TYPE_BASIC_AUTH;
        }
        if (this.getTlsClientCertificateSelector() != null) {
            return TYPE_TLS_CLIENT;
        }
        return TYPE_DEFAULT;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public String getPassword() {
        return this.password;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public Object getRequestLock() {
        return this.requestLock;
    }

    public String getTip() {
        return this.getLabel() + " @ " + this.getUrl();
    }

    public IX509CertificateFilter getTlsClientCertificateSelector() {
        return this.tlsClientCertificateSelector;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isSynchronizeRequests() {
        return this.synchronizeRequests;
    }

    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        element.setName("service");
        element.setAttributeValue("url", this.getUrl());
        String type = TYPE_DEFAULT;
        IElement eAuth = element.newElementMapped("auth");
        if (this.getUser() != null && this.getPassword() != null) {
            type = TYPE_BASIC_AUTH;
            if (this.getUser() != null) {
                eAuth.setAttributeValue("user", this.getUser());
            }
            if (this.getPassword() != null) {
                eAuth.setAttributeValue("password", this.getPassword());
            }
        } else if (this.getTlsClientCertificateSelector() != null) {
            IFactory factory;
            type = TYPE_TLS_CLIENT;
            IX509CertificateFilter selector = this.getTlsClientCertificateSelector();
            IElement tempElement = element.newElementMapped("tlsClientCertificate");
            if (selector instanceof IElementSerializable) {
                ((IElementSerializable)selector).serialize(tempElement);
            } else if (selector instanceof IFactorySupport && (factory = ((IFactorySupport)selector).getFactory()) instanceof IElementSerializationHandler) {
                ((IElementSerializationHandler)factory).serialize((Object)selector, tempElement);
            }
        }
        eAuth.setAttributeValue("type", type);
        ElementTools.putObject((IElement)element, (String)"hostnameVerifier", (Object)this.getHostnameVerifier());
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setSynchronizeRequests(boolean synchronizeRequests) {
        this.synchronizeRequests = synchronizeRequests;
    }

    public void setTlsClientCertificateSelector(IX509CertificateFilter sslClientCertificateSelector) {
        this.tlsClientCertificateSelector = sslClientCertificateSelector;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        return this.getLabel() + "@" + this.getUrl();
    }
}

