/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.httptimestamp.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.NoPolicy;
import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.httptimestamp.app.HttpTimestampCreatorFactory;
import de.intarsys.security.device.httptimestamp.device.HttpTimestampDevice;
import de.intarsys.security.device.httptimestamp.device.PACKAGE;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.List;

public class HttpTimestampDeviceProvider
extends CommonDeviceProvider<HttpTimestampDevice> {
    public static final String ARG_URL = "url";
    public static final String ARG_USER = "user";
    public static final String ARG_PASSWORD = "password";
    public static final String ARG_HTTP_CONNECT_TIMEOUT = "httpConnectTimeout";
    public static final String ARG_HTTP_READ_TIMEOUT = "httpReadTimeout";
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected HttpTimestampDevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        HttpTimestampDevice device = new HttpTimestampDevice(this, this.getId(args));
        device.setUrl(ArgTools.getString((IArgs)args, (String)ARG_URL, null));
        device.setUser(ArgTools.getString((IArgs)args, (String)ARG_USER, null));
        device.setPassword(ArgTools.getString((IArgs)args, (String)ARG_PASSWORD, null));
        device.setConnectTimeout(ArgTools.getInt((IArgs)args, (String)ARG_HTTP_CONNECT_TIMEOUT, (int)5000));
        device.setReadTimeout(ArgTools.getInt((IArgs)args, (String)ARG_HTTP_READ_TIMEOUT, (int)60000));
        return device;
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        HttpTimestampCreatorFactory descriptor = new HttpTimestampCreatorFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(ITimestampCreator.class);
        apps.add((IApplicationDescriptor)descriptor);
    }

    @PreDestroy
    public void destroy() {
        Outlet.get().unregisterFactory(this.getId());
        DeviceProviderRegistry.get().unregisterDeviceProvider((IDeviceProvider)this);
    }

    @PostConstruct
    public void init() {
        super.init();
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
        Outlet.get().registerFactory("de.intarsys.security.device.httptimestamp.device.HttpTimestampDeviceProvider", (IFactory)this);
    }
}

