/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.digest;

import de.intarsys.document.common.CommonDocumentType;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.document.type.digest.DigestDocument;
import de.intarsys.document.type.digest.PACKAGE;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.TransientLocator;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;

public class DigestDocumentType
extends CommonDocumentType<DigestDocument, IDigest> {
    public static final String ID = DigestDocumentType.class.getName();
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected DigestDocument basicCreateFromImpl(ILocator locator, Object impl) throws IOException {
        IDigest digest;
        if (locator == null) {
            locator = this.createLocator(null);
        }
        if ((digest = DigestTools.createDigest((Object)impl)) instanceof IDigest) {
            return new DigestDocument((IDocumentType<DigestDocument, IDigest>)this, locator, digest);
        }
        return null;
    }

    protected DigestDocument basicCreateFromLocator(ILocator locator, IArgs args) throws IOException {
        IDigest digest = DigestTools.createDigest((Object)locator);
        return new DigestDocument((IDocumentType<DigestDocument, IDigest>)this, locator, digest);
    }

    protected DigestDocument basicCreateNew(IArgs args) {
        ILocator locator = this.createLocator(null);
        return new DigestDocument((IDocumentType<DigestDocument, IDigest>)this, locator, null);
    }

    protected ILocator createLocator(Object impl) {
        ILocator locator = super.createLocator(impl);
        ((TransientLocator)locator).setAlwaysUnchanged(true);
        return locator;
    }

    protected String getBaseName(Object impl) {
        return Msg.getString("DigestDocument.BaseName", new Object[0]);
    }

    protected String getBaseType(Object impl) {
        return Msg.getString("DigestDocument.BaseType", new Object[0]);
    }

    protected String getDefaultDefaultExtension() {
        return "der";
    }

    protected String getDefaultDefaultMimeType() {
        return "application/digest";
    }

    public String getLabel() {
        return "Digest";
    }
}

