/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.graphic;

import java.awt.Color;

public class ColorTools {
    public static int LINEARCOLORS = 1536;

    public static Color getColor(int max, int color) {
        return ColorTools.getLinearColor(LINEARCOLORS / max * color);
    }

    public static Color getLinearColor(int color) {
        int r = 0;
        int g = 0;
        int b = 0;
        if ((color %= LINEARCOLORS) < 256) {
            r = 255;
            g = color;
            b = 0;
        } else if (color < 512) {
            r = 511 - color;
            g = 255;
            b = 0;
        } else if (color < 768) {
            r = 0;
            g = 255;
            b = color - 512;
        } else if (color < 1024) {
            r = 0;
            g = 1023 - color;
            b = 255;
        } else if (color < 1280) {
            r = color - 1024;
            g = 0;
            b = 255;
        } else if (color < 1536) {
            r = 255;
            g = 0;
            b = 1535 - color;
        }
        return new Color(r, g, b);
    }

    private ColorTools() {
    }
}

