/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.graphic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public abstract class Component2D {
    private Component2D parent;
    private int _ox;
    private int _oy;
    private int _height;
    private int _width;
    private int _x;
    private int _y;
    private double rotation;
    private String debugMode;

    public Component2D() {
    }

    public Component2D(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void drawOn(Graphics2D g) {
        AffineTransform t = g.getTransform();
        g.translate(this.getX(), this.getY());
        g.rotate(Math.toRadians(this.getRotation()));
        g.translate(-this.getX(), -this.getY());
        this.paint(g);
        g.setTransform(t);
    }

    public String getDebugMode() {
        if (this.debugMode == null && this.getParent() != null) {
            return this.getParent().getDebugMode();
        }
        return this.debugMode;
    }

    public int getHeight() {
        return this._height;
    }

    public int getLeft(Graphics2D g) {
        double widthProjection;
        double alpha = Math.toRadians(this.getRotation());
        double left = 0.0;
        double heightProjection = Math.sin(alpha) * (double)this.getHeight();
        if (heightProjection > 0.0) {
            left -= heightProjection;
        }
        if ((widthProjection = Math.cos(alpha) * (double)this.getWidth()) < 0.0) {
            left += widthProjection;
        }
        return (int)left;
    }

    public int getOriginX() {
        return this._ox;
    }

    public int getOriginY() {
        return this._oy;
    }

    public Component2D getParent() {
        return this.parent;
    }

    public int getPreferredHeight(Graphics2D g) {
        return this._height;
    }

    public int getPreferredWidth(Graphics2D g) {
        return this._width;
    }

    public int getRight(Graphics2D g) {
        double widthProjection;
        double alpha = Math.toRadians(this.getRotation());
        double val = 0.0;
        double heightProjection = Math.sin(alpha) * (double)this.getHeight();
        if (heightProjection < 0.0) {
            val -= heightProjection;
        }
        if ((widthProjection = Math.cos(alpha) * (double)this.getWidth()) > 0.0) {
            val += widthProjection;
        }
        return (int)val;
    }

    public double getRotation() {
        return this.rotation;
    }

    public int getTop(Graphics2D g) {
        double widthProjection;
        double alpha = Math.toRadians(this.getRotation());
        double left = 0.0;
        double heightProjection = Math.cos(alpha) * (double)this.getHeight();
        if (heightProjection < 0.0) {
            left += heightProjection;
        }
        if ((widthProjection = Math.sin(alpha) * (double)this.getWidth()) < 0.0) {
            left += widthProjection;
        }
        return (int)left;
    }

    public int getTransformedHeight() {
        double alpha = Math.toRadians(this.getRotation());
        return (int)(Math.abs(Math.sin(alpha) * (double)this.getWidth()) + Math.abs(Math.cos(alpha) * (double)this.getHeight()));
    }

    public int getTransformedHeight(Graphics2D g) {
        return this.getTransformedHeight();
    }

    public int getTransformedOriginX() {
        double alpha = Math.toRadians(this.getRotation());
        double ox = 0.0;
        ox = Math.max(0.0, Math.sin(alpha) * (double)this.getHeight());
        return (int)(ox -= Math.min(0.0, Math.cos(alpha) * (double)this.getWidth()));
    }

    public int getTransformedOriginX(Graphics2D g) {
        return this.getTransformedOriginX();
    }

    public int getTransformedOriginY() {
        double alpha = Math.toRadians(this.getRotation());
        double oy = 0.0;
        oy -= Math.min(0.0, Math.sin(alpha) * (double)this.getWidth());
        return (int)(oy -= Math.min(0.0, Math.cos(alpha) * (double)this.getHeight()));
    }

    public int getTransformedOriginY(Graphics2D g) {
        return this.getTransformedOriginY();
    }

    public int getTransformedWidth() {
        double alpha = Math.toRadians(this.getRotation());
        return (int)(Math.abs(Math.cos(alpha) * (double)this.getWidth()) + Math.abs(Math.sin(alpha) * (double)this.getHeight()));
    }

    public int getTransformedWidth(Graphics2D g) {
        return this.getTransformedWidth();
    }

    public int getWidth() {
        return this._width;
    }

    public int getX() {
        return this._x;
    }

    public int getY() {
        return this._y;
    }

    public boolean hasDebugFlag(String flag) {
        if (!this.isDebugMode()) {
            return false;
        }
        return this.getDebugMode().toLowerCase().indexOf(flag.toLowerCase()) >= 0;
    }

    public boolean isDebugMode() {
        return this.getDebugMode() != null && !this.getDebugMode().equals("");
    }

    public void move(int x, int y) {
        this._x += x;
        this._y += y;
    }

    public void moveTo(int x, int y) {
        this._x = x;
        this._y = y;
    }

    public void paint(Graphics2D g) {
        this.paintDebug(g);
    }

    public void paintDebug(Graphics2D g) {
        if (this.hasDebugFlag("boundingbox")) {
            g.setStroke(new BasicStroke());
            g.setColor(new Color(255, 0, 0));
            g.drawRect(this.getX(), this.getY(), this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    public void resize(int width, int height) {
        this._width += width;
        this._height += height;
    }

    public void resizeTo(int width, int height) {
        this._width = width;
        this._height = height;
    }

    public void setDebugMode(String newDebugMode) {
        this.debugMode = newDebugMode;
    }

    public void setHeight(int new_height) {
        this._height = new_height;
    }

    public void setParent(Component2D newParent) {
        this.parent = newParent;
    }

    public void setRotation(double newRotation) {
        this.rotation = newRotation;
    }

    public void setWidth(int new_width) {
        this._width = new_width;
    }

    public void setX(int new_x) {
        this._x = new_x;
    }

    public void setY(int new_y) {
        this._y = new_y;
    }
}

