/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.graphic;

import de.intarsys.graphic.ColorTools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.List;

public class FillStyle {
    public static FillStyle Black = new FillStyle(Color.black);
    public static FillStyle Default = new FillStyle(Color.white);
    public static FillStyle White = new FillStyle(Color.white);
    private Paint paint;

    public static FillStyle getFillStyle(int max, int index) {
        return new FillStyle(ColorTools.getColor(max, index));
    }

    public static FillStyle[] getFillStyles(int num) {
        FillStyle[] styles = new FillStyle[num];
        for (int i = 0; i < num; ++i) {
            styles[i] = new FillStyle(ColorTools.getColor(num, i));
        }
        return styles;
    }

    public static FillStyle[] getFillStyles(List colors) {
        FillStyle[] styles = new FillStyle[colors.size()];
        try {
            for (int i = 0; i < colors.size(); ++i) {
                List segmentColor = (List)colors.get(i);
                styles[i] = new FillStyle(new Color(Integer.valueOf(segmentColor.get(0).toString()), Integer.valueOf(segmentColor.get(1).toString()), Integer.valueOf(segmentColor.get(2).toString())));
            }
        }
        catch (ClassCastException ccx) {
            styles = FillStyle.getFillStyles(colors.size());
        }
        catch (NumberFormatException nfx) {
            styles = FillStyle.getFillStyles(colors.size());
        }
        return styles;
    }

    public FillStyle(List colors) {
        this.setPaint(new Color(((Number)colors.get(0)).intValue(), ((Number)colors.get(1)).intValue(), ((Number)colors.get(2)).intValue()));
    }

    public FillStyle(Paint p) {
        this.setPaint(p);
    }

    public FillStyle brighter() {
        if (this.getPaint() instanceof Color) {
            return new FillStyle(((Color)this.getPaint()).brighter());
        }
        return this;
    }

    public FillStyle darker() {
        if (this.getPaint() instanceof Color) {
            return new FillStyle(((Color)this.getPaint()).darker());
        }
        return this;
    }

    public void formatGraphics(Graphics2D g) {
        g.setPaint(this.getPaint());
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint newPaint) {
        this.paint = newPaint;
    }
}

