/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.graphic;

import de.intarsys.graphic.Component2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageTools {
    private static Component component = new Component(){
        private static final long serialVersionUID = 3257284729769507120L;
    };
    private static int counter = 0;
    private static MediaTracker tracker = new MediaTracker(component);

    @Deprecated
    public static Image draw(Component2D c) {
        return ImageTools.drawImageRGB(c);
    }

    @Deprecated
    public static Image drawBW(Component2D c) {
        return ImageTools.drawImageBW(c);
    }

    public static BufferedImage drawImageBW(Component2D component2D) {
        BufferedImage img = new BufferedImage(1, 1, 12);
        Graphics2D graphics = img.createGraphics();
        int h = component2D.getTransformedHeight(graphics);
        int w = component2D.getTransformedWidth(graphics);
        if (h == 0 || w == 0) {
            return null;
        }
        img = new BufferedImage(w, h, 12);
        graphics = img.createGraphics();
        graphics.setPaint(Color.white);
        graphics.fillRect(0, 0, w, h);
        graphics.translate(component2D.getTransformedOriginX(graphics), component2D.getTransformedOriginY(graphics));
        component2D.drawOn(graphics);
        return img;
    }

    public static BufferedImage drawImageRGB(Component2D component2D) {
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D graphics = img.createGraphics();
        int h = component2D.getTransformedHeight(graphics);
        int w = component2D.getTransformedWidth(graphics);
        if (h == 0 || w == 0) {
            return null;
        }
        img = new BufferedImage(w, h, 1);
        graphics = img.createGraphics();
        graphics.translate(component2D.getTransformedOriginX(graphics), component2D.getTransformedOriginY(graphics));
        component2D.drawOn(graphics);
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static PixelGrabber grabImage(Image image) throws IOException {
        int id;
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            id = counter++;
        }
        tracker.addImage(image, id);
        try {
            tracker.waitForID(id);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("image loading interrupted");
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, image.getWidth(null), image.getHeight(null), true);
        try {
            if (!pg.grabPixels()) {
                throw new IOException("error loading image");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("image loading interrupted");
        }
        if ((pg.getStatus() & 0x80) != 0) {
            throw new IOException("error loading image");
        }
        return pg;
    }

    public static BufferedImage load(InputStream stream) throws IOException {
        return ImageIO.read(stream);
    }

    public static BufferedImage load(String fileName) throws IOException {
        try (FileInputStream stream = new FileInputStream(fileName);){
            BufferedImage bufferedImage = ImageTools.load(stream);
            return bufferedImage;
        }
    }

    @Deprecated
    public static Image loadFromFile(String fileName) throws IOException {
        return ImageTools.load(fileName);
    }

    @Deprecated
    public static Image loadFromStream(InputStream stream) throws IOException {
        return ImageTools.load(stream);
    }

    public static void save(BufferedImage image, OutputStream stream) throws IOException {
        ImageTools.save(image, stream, "png");
    }

    public static void save(BufferedImage image, OutputStream stream, String formatName) throws IOException {
        if (!ImageIO.write((RenderedImage)image, formatName, stream)) {
            throw new IOException("could not write image");
        }
    }

    public static void save(BufferedImage image, String fileName) throws IOException {
        ImageTools.save(image, fileName, "png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(BufferedImage image, String fileName, String formatName) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(fileName);){
            ImageIO.write((RenderedImage)image, formatName, stream);
        }
    }

    @Deprecated
    public static void saveToFile(Image img, String fileName) throws IOException {
        ImageTools.saveToFile(img, fileName, "image/png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void saveToFile(Image img, String fileName, String mimeType) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(fileName);){
            ImageTools.saveToStream(img, stream, mimeType);
        }
    }

    @Deprecated
    public static void saveToStream(Image img, OutputStream outs) throws IOException {
        ImageTools.saveToStream(img, outs, "image/png");
    }

    @Deprecated
    public static void saveToStream(Image img, OutputStream outs, String mimeType) throws IOException {
        DataFlavor flavor;
        BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.drawImage(img, 0, 0, null);
        graphics.dispose();
        try {
            flavor = new DataFlavor(mimeType);
        }
        catch (ClassNotFoundException ex) {
            throw new InternalError("execution should not reach this point");
        }
        ImageTools.save(bufferedImage, outs, flavor.getSubType());
    }

    private ImageTools() {
    }
}

