/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.graphic;

import de.intarsys.graphic.ColorTools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;

public class LineStyle {
    public static LineStyle Default = new LineStyle(new BasicStroke(), Color.black);
    private Paint paint;
    private Stroke stroke;

    public static LineStyle getLineStyle(int max, int color) {
        return new LineStyle(new BasicStroke(1.0f), ColorTools.getColor(max, color));
    }

    public static LineStyle[] getLineStyles(int num) {
        LineStyle[] styles = new LineStyle[num];
        for (int i = 0; i < num; ++i) {
            styles[i] = new LineStyle(new BasicStroke(1.0f), ColorTools.getColor(num, i));
        }
        return styles;
    }

    public LineStyle() {
    }

    public LineStyle(Stroke s, Paint p) {
        this.setStroke(s);
        this.setPaint(p);
    }

    public LineStyle brighter() {
        if (this.getPaint() instanceof Color) {
            return new LineStyle(this.getStroke(), ((Color)this.getPaint()).brighter());
        }
        return this;
    }

    public LineStyle darker() {
        if (this.getPaint() instanceof Color) {
            return new LineStyle(this.getStroke(), ((Color)this.getPaint()).darker());
        }
        return this;
    }

    public void formatGraphics(Graphics2D g) {
        if (this.getStroke() != null) {
            g.setStroke(this.getStroke());
        }
        if (this.getPaint() != null) {
            g.setPaint(this.getPaint());
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setPaint(Paint newPaint) {
        this.paint = newPaint;
    }

    public void setStroke(Stroke newStroke) {
        this.stroke = newStroke;
    }
}

