/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.graphic;

import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;

public class ShapePanel
extends Canvas {
    private Shape shape;

    public static void create(Shape shape) {
        ShapePanel viewer = new ShapePanel(shape);
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        JFrame f = new JFrame("ShapePanel");
        f.setSize(new Dimension(200, 300));
        f.addWindowListener(l);
        f.getContentPane().setLayout(new GridLayout(1, 1));
        f.getContentPane().add(viewer);
        f.pack();
        f.setVisible(true);
    }

    public ShapePanel(Shape shape) {
        this.setShape(shape);
    }

    public Shape getShape() {
        return this.shape;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.WHITE);
        super.paint(g);
        if (this.getShape() == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform transform = g2.getTransform();
        int width = this.getWidth();
        int height = this.getHeight();
        g2.translate(10, 10);
        Rectangle2D bound = this.getShape().getBounds2D();
        double scaleX = (double)(this.getWidth() - 20) / bound.getWidth();
        double scaleY = (double)(this.getHeight() - 20) / bound.getHeight();
        double scale = Math.min(scaleX, scaleY);
        g2.scale(scale, scale);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke((float)(1.0 / scale)));
        g2.draw(this.getShape());
        g2.setTransform(transform);
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }
}

