/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.graphic;

import de.intarsys.graphic.Component2D;
import de.intarsys.graphic.FillStyle;
import de.intarsys.graphic.LineStyle;
import de.intarsys.graphic.TextStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public abstract class StandardComponent2D
extends Component2D {
    private FillStyle background = null;
    private LineStyle border = null;
    private FillStyle fillStyle = null;
    private LineStyle lineStyle = null;
    private TextStyle textStyle = null;
    private boolean antialiasing = false;
    private boolean textAntialiasing = false;

    public StandardComponent2D() {
    }

    public StandardComponent2D(int width, int height) {
        super(width, height);
    }

    public FillStyle getBackground() {
        if (this.background == null) {
            this.background = this.getDefaultBackground();
        }
        return this.background;
    }

    public LineStyle getBorder() {
        if (this.border == null) {
            this.border = this.getDefaultBorder();
        }
        return this.border;
    }

    public FillStyle getDefaultBackground() {
        return null;
    }

    public LineStyle getDefaultBorder() {
        return null;
    }

    public FillStyle getDefaultFillStyle() {
        return FillStyle.Black;
    }

    public LineStyle getDefaultLineStyle() {
        return null;
    }

    public TextStyle getDefaultTextStyle() {
        return new TextStyle("Arial", 0, 10, Color.black);
    }

    public FillStyle getFillStyle() {
        if (this.fillStyle == null) {
            this.fillStyle = this.getDefaultFillStyle();
        }
        return this.fillStyle;
    }

    public LineStyle getLineStyle() {
        if (this.lineStyle == null) {
            this.lineStyle = this.getDefaultLineStyle();
        }
        return this.lineStyle;
    }

    public TextStyle getTextStyle() {
        if (this.textStyle == null) {
            this.textStyle = this.getDefaultTextStyle();
        }
        return this.textStyle;
    }

    public boolean isAntialiasing() {
        return this.antialiasing;
    }

    public boolean isTextAntialiasing() {
        return this.textAntialiasing;
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.isTextAntialiasing()) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        this.paintBackground(g);
        this.paintForeground(g);
        this.paintDebug(g);
    }

    public void paintBackground(Graphics2D g) {
        if (this.getBackground() != null) {
            this.getBackground().formatGraphics(g);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void paintForeground(Graphics2D g) {
    }

    public void setAntialiasing(boolean newAntialias) {
        this.antialiasing = newAntialias;
    }

    public void setBackground(FillStyle newBackground) {
        this.background = newBackground;
    }

    public void setBorder(LineStyle newBorder) {
        this.border = newBorder;
    }

    public void setFillStyle(FillStyle newFillStyle) {
        this.fillStyle = newFillStyle;
    }

    public void setLineStyle(LineStyle newLineStyle) {
        this.lineStyle = newLineStyle;
    }

    public void setTextAntialiasing(boolean newTextAntialias) {
        this.textAntialiasing = newTextAntialias;
    }

    public void setTextStyle(TextStyle newFontStyle) {
        this.textStyle = newFontStyle;
    }
}

