/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.layout;

import de.intarsys.layout.CAlignment;
import de.intarsys.layout.CAxis;
import de.intarsys.layout.CBorderPolicy;
import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.ILayoutContainer;
import de.intarsys.layout.LayoutContainer;
import java.awt.geom.Rectangle2D;

public class Aligner {
    private final Rectangle2D boundingBox;
    private final LayoutContainer layoutContainer;
    private int axis = CAxis.X;
    private int alignment = CAlignment.LEFT;
    private int borderPolicy = CBorderPolicy.FIX;

    public Aligner(Rectangle2D boundingBox, LayoutContainer container) {
        this.boundingBox = boundingBox;
        this.layoutContainer = container;
    }

    public void align() {
        this.align(false);
    }

    public void align(boolean paragraphEnd) {
        LayoutContainer tempContainer = this.layoutContainer;
        tempContainer.trim();
        if (this.axis == CAxis.X) {
            float containerWidth = tempContainer.getWidth();
            float boxWidth = (float)this.getBoundingBox().getWidth();
            if (this.getBorderPolicy() == CBorderPolicy.GROW && containerWidth > boxWidth) {
                boxWidth = containerWidth;
            }
            float dmin = (float)(this.getBoundingBox().getMinX() - (double)tempContainer.getMinX());
            tempContainer.move(dmin, 0.0f);
            if (this.getAlignment() == CAlignment.LEFT) {
                tempContainer.setWidth(boxWidth);
            } else if (this.getAlignment() == CAlignment.CENTER) {
                tempContainer.setWidth(boxWidth);
                tempContainer.moveChildren((boxWidth - containerWidth) / 2.0f, 0.0f);
            } else if (this.getAlignment() == CAlignment.RIGHT) {
                tempContainer.setWidth(boxWidth);
                tempContainer.moveChildren(boxWidth - containerWidth, 0.0f);
            } else if (this.getAlignment() == CAlignment.JUSTIFY) {
                if (paragraphEnd) {
                    tempContainer.setWidth(boxWidth);
                } else {
                    this.blockHorizontal(tempContainer, boxWidth);
                }
            } else {
                this.blockHorizontal(tempContainer, boxWidth);
            }
        } else {
            float containerHeight = tempContainer.getHeight();
            float boxHeight = (float)this.getBoundingBox().getHeight();
            if (this.getBorderPolicy() == CBorderPolicy.GROW && containerHeight > boxHeight) {
                boxHeight = containerHeight;
            }
            float dmin = (float)(this.getBoundingBox().getMinY() - (double)tempContainer.getMinY());
            tempContainer.move(0.0f, dmin);
            if (this.getAlignment() == CAlignment.BOTTOM) {
                tempContainer.setHeight(boxHeight);
            } else if (this.getAlignment() == CAlignment.CENTER) {
                tempContainer.setHeight(boxHeight);
                tempContainer.moveChildren(0.0f, (boxHeight - containerHeight) / 2.0f);
            } else if (this.getAlignment() == CAlignment.TOP) {
                tempContainer.setHeight(boxHeight);
                tempContainer.moveChildren(0.0f, boxHeight - containerHeight);
            } else {
                this.blockVertical(tempContainer, boxHeight);
            }
        }
    }

    protected void blockHorizontal(ILayoutContainer container, float width) {
        if (container.isFixed()) {
            return;
        }
        float factor = width / container.getWidth();
        if (factor == 1.0f) {
            return;
        }
        container.setWidth(width);
        ILayoutComponent[] children = container.children();
        int scalableCount = 0;
        for (ILayoutComponent child : children) {
            if (!(child.getWidth() > 0.0f)) continue;
            ++scalableCount;
        }
        int scalableIndex = 0;
        for (int i = 0; i < children.length; ++i) {
            ILayoutComponent element = children[i];
            float delta = element.getMinX() - container.getMinX();
            float newDelta = delta * factor;
            float newPosition = container.getMinX() + newDelta;
            float newExtension = element.getWidth() * factor;
            if (element instanceof ILayoutContainer) {
                this.blockHorizontal((ILayoutContainer)element, newExtension);
            } else if (scalableIndex != 0) {
                newPosition = scalableIndex == scalableCount - 1 ? container.getMaxX() - element.getWidth() : (newPosition += (newExtension - element.getWidth()) / 2.0f);
            }
            element.moveTo(newPosition, element.getMinY());
            if (!(element.getWidth() > 0.0f)) continue;
            ++scalableIndex;
        }
    }

    protected void blockVertical(ILayoutContainer container, float height) {
        if (container.isFixed()) {
            return;
        }
        float factor = height / container.getHeight();
        if (factor == 1.0f) {
            return;
        }
        container.setHeight(height);
        ILayoutComponent[] children = container.children();
        int length = children.length;
        for (int i = 0; i < length; ++i) {
            ILayoutComponent element = children[i];
            float delta = element.getMinY() - container.getMinY();
            float newDelta = delta * factor;
            float newPosition = container.getMinY() + newDelta;
            float newExtension = element.getHeight() * factor;
            if (element instanceof ILayoutContainer) {
                this.blockVertical((ILayoutContainer)element, newExtension);
            } else {
                newPosition += newExtension / (float)length * (float)i;
            }
            element.moveTo(element.getMinX(), newPosition);
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getAxis() {
        return this.axis;
    }

    public int getBorderPolicy() {
        return this.borderPolicy;
    }

    public Rectangle2D getBoundingBox() {
        return this.boundingBox;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setAxis(int axis) {
        this.axis = axis;
    }

    public void setBorderPolicy(int borderPolicy) {
        this.borderPolicy = borderPolicy;
    }
}

