/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.layout;

import de.intarsys.layout.CAlignment;
import de.intarsys.layout.CAxis;
import de.intarsys.layout.CBorderPolicy;
import de.intarsys.layout.CDirection;
import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.LayoutContainer;
import de.intarsys.layout.LayoutPrimitive;
import de.intarsys.layout.LinearLayouter;
import de.intarsys.layout.RectLayouter;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class BilinearLayouter
extends RectLayouter {
    private int currentlines = 0;
    private boolean forceFirstLine = true;
    private int maxlines = -1;
    private LinearLayouter primary;
    private int primaryAlignment = CAlignment.LEFT;
    private int primaryBorderPolicy = CBorderPolicy.FIX;
    private int primaryDirection = CDirection.ASCENDING;
    private boolean replayMode = false;
    private LinearLayouter secondary;
    private int secondaryAlignment = CAlignment.TOP;
    private int secondaryBorderPolicy = CBorderPolicy.FIX;
    private int secondaryDirection = CDirection.DESCENDING;

    public BilinearLayouter(Rectangle2D bbox) {
        super(bbox);
        this.primary = new LinearLayouter(this.getBoundingBox());
        this.secondary = new LinearLayouter(this.getBoundingBox());
        this.getPrimary().setDirection(this.getPrimaryDirection());
        this.getPrimary().setBorderPolicy(this.getPrimaryBorderPolicy());
        this.getSecondary().setDirection(this.getSecondaryDirection());
        this.getSecondary().setAxis(CAxis.VERTICAL);
        this.getSecondary().setBorderPolicy(this.getSecondaryBorderPolicy());
    }

    public List add(ILayoutComponent element, boolean force) {
        List result = this.getPrimary().add(element, force);
        if (result != null) {
            List secondaryOverflow = this.newLine();
            if (secondaryOverflow == null) {
                if (this.getMaxlines() != 1) {
                    ILayoutComponent lc;
                    List forcedOverflow = null;
                    Iterator it = result.iterator();
                    while (it.hasNext() && (forcedOverflow = this.add(lc = (ILayoutComponent)it.next(), true)) == null) {
                    }
                    while (it.hasNext()) {
                        lc = (ILayoutComponent)it.next();
                        forcedOverflow.add(lc);
                    }
                    result = forcedOverflow;
                }
            } else {
                secondaryOverflow.addAll(result);
                result = secondaryOverflow;
            }
        }
        return result;
    }

    protected List addLine(LayoutContainer line) {
        line.setFixed(true);
        List<ILayoutComponent> overflow = this.getSecondary().add(line, false);
        if (overflow != null) {
            if (this.isForceFirstLine() && this.getSecondary().getLayoutContainer().size() == 0) {
                this.getSecondary().add(line, true);
                overflow = null;
            } else {
                List<ILayoutComponent> splitLine = null;
                if (this.isReplayMode() || line.getHeight() >= this.getSecondary().getMax()) {
                    float maxHeight = this.getSecondary().getMax() - this.getSecondary().getLinearPosition();
                    splitLine = line.splitVertical(maxHeight, this.getSecondaryDirection() == CDirection.DESCENDING);
                }
                ArrayList<ILayoutComponent> result = new ArrayList<ILayoutComponent>();
                if (splitLine == null) {
                    for (LayoutContainer layoutContainer : overflow) {
                        result.addAll(Arrays.asList(layoutContainer.children()));
                    }
                } else {
                    LayoutContainer first = (LayoutContainer)splitLine.get(0);
                    LayoutContainer layoutContainer = (LayoutContainer)splitLine.get(1);
                    this.getSecondary().add(first, true);
                    result.addAll(Arrays.asList(layoutContainer.children()));
                }
                overflow = result;
            }
        }
        return overflow;
    }

    public List close() {
        List result = this.newLine();
        return result;
    }

    protected int getCurrentlines() {
        return this.currentlines;
    }

    @Override
    public LayoutContainer getLayoutContainer() {
        return this.getSecondary().getLayoutContainer();
    }

    public Point2D getLayoutPosition() {
        if (this.getPrimary().getLayoutContainer().size() == 0) {
            LayoutContainer container = this.getSecondary().getLayoutContainer();
            ILayoutComponent[] children = container.children();
            if (children.length == 0) {
                return new Point2D.Float(0.0f, 0.0f);
            }
            LayoutContainer previous = (LayoutContainer)children[children.length - 1];
            return new Point2D.Float(previous.getWidth(), container.getHeight() - previous.getHeight());
        }
        return new Point2D.Float(this.getPrimary().getLinearPosition(), this.getSecondary().getLinearPosition());
    }

    public int getMaxlines() {
        return this.maxlines;
    }

    protected LinearLayouter getPrimary() {
        return this.primary;
    }

    public int getPrimaryAlignment() {
        return this.primaryAlignment;
    }

    public int getPrimaryBorderPolicy() {
        return this.primaryBorderPolicy;
    }

    public int getPrimaryDirection() {
        return this.primaryDirection;
    }

    protected LinearLayouter getSecondary() {
        return this.secondary;
    }

    public int getSecondaryAlignment() {
        return this.secondaryAlignment;
    }

    public int getSecondaryBorderPolicy() {
        return this.secondaryBorderPolicy;
    }

    public int getSecondaryDirection() {
        return this.secondaryDirection;
    }

    public boolean isForceFirstLine() {
        return this.forceFirstLine;
    }

    public boolean isReplayMode() {
        return this.replayMode;
    }

    public List newLine() {
        ArrayList<ILayoutComponent> result = this.getPrimary().close();
        LayoutContainer box = this.getPrimary().getLayoutContainer();
        if (box.size() == 0) {
            return result;
        }
        ArrayList<ILayoutComponent> secondaryOverflow = null;
        secondaryOverflow = this.getMaxlines() != -1 && this.getCurrentlines() == this.getMaxlines() ? new ArrayList<ILayoutComponent>(Arrays.asList(box.children())) : this.addLine(box);
        if (secondaryOverflow != null) {
            if (result != null) {
                secondaryOverflow.addAll(result);
            }
            result = secondaryOverflow;
        } else {
            this.setCurrentlines(this.getCurrentlines() + 1);
        }
        this.getPrimary().reset();
        return result;
    }

    @Override
    public void removeLast() {
        if (this.getPrimary().getLayoutContainer().size() > 0) {
            this.getPrimary().removeLast();
        }
        if (this.getPrimary().getLayoutContainer().size() == 0) {
            if (this.getLayoutContainer().size() == 0) {
                return;
            }
            ILayoutComponent[] components = this.getLayoutContainer().children();
            ILayoutComponent component = components[components.length - 1];
            this.getLayoutContainer().remove(component);
            this.getPrimary().setLayoutContainer((LayoutContainer)component);
            this.getPrimary().resetContainer();
        }
    }

    protected void setCurrentlines(int currentlines) {
        this.currentlines = currentlines;
    }

    public void setForceFirstLine(boolean b) {
        this.forceFirstLine = b;
    }

    public void setLayoutPosition(float x, float y) {
        this.newLine();
        this.add(new LayoutPrimitive(0.0f, y), true);
        this.newLine();
        this.add(new LayoutPrimitive(x, 0.0f), true);
    }

    public void setMaxlines(int maxlines) {
        this.maxlines = maxlines;
    }

    public void setPrimaryAlignment(int newAlignment) {
        this.primaryAlignment = newAlignment;
    }

    public void setPrimaryBorderPolicy(int primaryBorderPolicy) {
        this.primaryBorderPolicy = primaryBorderPolicy;
        this.getPrimary().setBorderPolicy(primaryBorderPolicy);
    }

    public void setPrimaryDirection(int primaryDirection) {
        this.primaryDirection = primaryDirection;
    }

    public void setReplayMode(boolean replayMode) {
        this.replayMode = replayMode;
    }

    public void setSecondaryAlignment(int newAlignment) {
        this.secondaryAlignment = newAlignment;
    }

    public void setSecondaryBorderPolicy(int secondaryBorderPolicy) {
        this.secondaryBorderPolicy = secondaryBorderPolicy;
        this.getSecondary().setBorderPolicy(secondaryBorderPolicy);
    }

    public void setSecondaryDirection(int secondaryDirection) {
        this.secondaryDirection = secondaryDirection;
    }
}

