/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.layout;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.ILayoutVisitor;
import java.awt.geom.Rectangle2D;
import java.util.List;

public abstract class LayoutComponent
implements ILayoutComponent {
    private float height;
    private float width;
    private float x;
    private float y;

    @Override
    public Object accept(ILayoutVisitor visitor) {
        return visitor.visitFromLayoutComponent(this);
    }

    @Override
    public Rectangle2D getBoundingBox() {
        return new Rectangle2D.Float(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getMaxX() {
        return this.getMinX() + this.getWidth();
    }

    @Override
    public float getMaxY() {
        return this.getMinY() + this.getHeight();
    }

    @Override
    public float getMinX() {
        return this.x;
    }

    @Override
    public float getMinY() {
        return this.y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public boolean isForced() {
        return false;
    }

    @Override
    public void move(float dX, float dY) {
        this.setMinX(this.getMinX() + dX);
        this.setMinY(this.getMinY() + dY);
    }

    @Override
    public void moveTo(float newX, float newY) {
        this.setMinX(newX);
        this.setMinY(newY);
    }

    @Override
    public void resetLayout() {
    }

    @Override
    public void setHeight(float newHeight) {
        this.height = newHeight;
    }

    protected void setMinX(float newX) {
        this.x = newX;
    }

    protected void setMinY(float newY) {
        this.y = newY;
    }

    @Override
    public void setWidth(float newWidth) {
        this.width = newWidth;
    }

    public List splitHorizontal(float max) {
        return null;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + "]";
    }

    @Override
    public void trim() {
    }
}

