/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.layout;

import de.intarsys.layout.Aligner;
import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.ILayoutContainer;
import de.intarsys.layout.ILayoutVisitor;
import de.intarsys.layout.ITrimmableComponent;
import de.intarsys.layout.LayoutComponent;
import de.intarsys.layout.LayoutPrimitive;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LayoutContainer
extends LayoutComponent
implements ILayoutContainer {
    private ILayoutComponent[] children = new ILayoutComponent[5];
    private boolean fixed = false;
    private int index = 0;
    private boolean splitAllowed = true;
    private ILayoutComponent theBottommost = null;
    private ILayoutComponent theLeftmost = null;
    private ILayoutComponent theRightmost = null;
    private ILayoutComponent theTopmost = null;

    @Override
    public Object accept(ILayoutVisitor visitor) {
        return visitor.visitFromLayoutContainer(this);
    }

    @Override
    public void add(ILayoutComponent element) {
        if (this.index >= this.children.length) {
            ILayoutComponent[] temp = new ILayoutComponent[this.children.length + 5];
            System.arraycopy(this.children, 0, temp, 0, this.children.length);
            this.children = temp;
        }
        this.children[this.index++] = element;
        this.include(element);
    }

    @Override
    public ILayoutComponent[] children() {
        ILayoutComponent[] copy = new ILayoutComponent[this.index];
        System.arraycopy(this.children, 0, copy, 0, Math.min(this.children.length, this.index));
        return copy;
    }

    @Override
    public Aligner createAligner(Rectangle2D boundingBox) {
        return new Aligner(boundingBox, this);
    }

    protected void enclose(boolean trim) {
        this.setMinX(0.0f);
        this.setMinY(0.0f);
        this.setWidth(0.0f);
        this.setHeight(0.0f);
        this.setTheBottommost(null);
        this.setTheLeftmost(null);
        this.setTheRightmost(null);
        this.setTheTopmost(null);
        for (int i = 0; i < this.index; ++i) {
            ILayoutComponent child = this.children[i];
            if (child instanceof ITrimmableComponent) {
                ITrimmableComponent trimmableElement = (ITrimmableComponent)child;
                if (trim && trimmableElement.isTrimmable()) continue;
            }
            this.include(child);
        }
    }

    protected void exclude(ILayoutComponent c) {
        boolean refreshBorders = false;
        if (c == this.getTheBottommost()) {
            refreshBorders = true;
        }
        if (c == this.getTheLeftmost()) {
            refreshBorders = true;
        }
        if (c == this.getTheTopmost()) {
            refreshBorders = true;
        }
        if (c == this.getTheRightmost()) {
            refreshBorders = true;
        }
        if (refreshBorders) {
            this.enclose(false);
        }
    }

    @Override
    public List<ILayoutComponent> getChildren() {
        return new ArrayList<ILayoutComponent>(Arrays.asList(this.children()));
    }

    public ILayoutComponent getTheBottommost() {
        return this.theBottommost;
    }

    public ILayoutComponent getTheLeftmost() {
        return this.theLeftmost;
    }

    public ILayoutComponent getTheRightmost() {
        return this.theRightmost;
    }

    public ILayoutComponent getTheTopmost() {
        return this.theTopmost;
    }

    protected void include(ILayoutComponent c) {
        if (this.getTheLeftmost() == null) {
            this.setTheLeftmost(c);
            this.setTheBottommost(c);
            this.setTheRightmost(c);
            this.setTheTopmost(c);
            this.setMinX(c.getMinX());
            this.setMinY(c.getMinY());
            this.setWidth(c.getWidth());
            this.setHeight(c.getHeight());
        } else {
            float oldmaxx = this.getMaxX();
            float oldmaxy = this.getMaxY();
            if (c.getMinX() < this.getMinX()) {
                this.setMinX(c.getMinX());
                this.setTheLeftmost(c);
            }
            if (c.getMinY() < this.getMinY()) {
                this.setMinY(c.getMinY());
                this.setTheBottommost(c);
            }
            if (c.getMaxX() > oldmaxx) {
                this.setWidth(c.getMaxX() - this.getMinX());
                this.setTheRightmost(c);
            } else {
                this.setWidth(oldmaxx - this.getMinX());
            }
            if (c.getMaxY() > oldmaxy) {
                this.setHeight(c.getMaxY() - this.getMinY());
                this.setTheTopmost(c);
            } else {
                this.setHeight(oldmaxy - this.getMinY());
            }
        }
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isSplitAllowed() {
        return this.splitAllowed;
    }

    @Override
    public void move(float dX, float dY) {
        super.move(dX, dY);
        for (int i = 0; i < this.index; ++i) {
            this.children[i].move(dX, dY);
        }
    }

    public void moveChildren(float dX, float dY) {
        for (int i = 0; i < this.index; ++i) {
            this.children[i].move(dX, dY);
        }
    }

    @Override
    public void moveTo(float newX, float newY) {
        float dx = newX - this.getMinX();
        float dy = newY - this.getMinY();
        this.move(dx, dy);
    }

    @Override
    public boolean remove(ILayoutComponent element) {
        boolean removed = false;
        for (int i = 0; i < this.index; ++i) {
            if (element != this.children[i]) continue;
            removed = true;
            --this.index;
            if (i < this.index) {
                System.arraycopy(this.children, i + 1, this.children, i, this.index - i);
            }
            this.children[this.index] = null;
            break;
        }
        if (removed) {
            this.exclude(element);
        }
        return removed;
    }

    public void setFixed(boolean fixedHeight) {
        this.fixed = fixedHeight;
    }

    public void setSplitAllowed(boolean splitAllowed) {
        this.splitAllowed = splitAllowed;
    }

    protected void setTheBottommost(ILayoutComponent component) {
        this.theBottommost = component;
    }

    protected void setTheLeftmost(ILayoutComponent component) {
        this.theLeftmost = component;
    }

    protected void setTheRightmost(ILayoutComponent component) {
        this.theRightmost = component;
    }

    protected void setTheTopmost(ILayoutComponent component) {
        this.theTopmost = component;
    }

    @Override
    public int size() {
        return this.index;
    }

    @Override
    public List<ILayoutComponent> splitVertical(float maxHeight, boolean reverse) {
        if (!this.isSplitAllowed() || this.children == null || this.children.length == 0) {
            return null;
        }
        float max = reverse ? this.getMaxY() - maxHeight : this.getMinY() + maxHeight;
        LayoutContainer first = null;
        LayoutContainer second = null;
        ILayoutComponent childFirst = null;
        ILayoutComponent childSecond = null;
        for (int i = 0; i < this.index; ++i) {
            ILayoutComponent child = this.children[i];
            if (!reverse && child.getMinY() > max) {
                childFirst = new LayoutPrimitive(child.getWidth(), 0.0f);
                childFirst.moveTo(child.getMinX(), max);
                childSecond = child;
            } else if (!reverse && child.getMaxY() > max) {
                childSplit = child.splitVertical(max - child.getMinY(), reverse);
                if (childSplit == null) {
                    childFirst = new LayoutPrimitive(child.getWidth(), 0.0f);
                    childFirst.moveTo(child.getMinX(), max);
                    childSecond = child;
                } else {
                    childFirst = childSplit.get(0);
                    childSecond = childSplit.get(1);
                }
            } else if (reverse && child.getMaxY() < max) {
                childFirst = new LayoutPrimitive(child.getWidth(), 0.0f);
                childFirst.moveTo(child.getMinX(), max);
                childSecond = child;
            } else if (reverse && child.getMinY() < max) {
                childSplit = child.splitVertical(child.getMaxY() - max, reverse);
                if (childSplit == null) {
                    childFirst = new LayoutPrimitive(child.getWidth(), 0.0f);
                    childFirst.moveTo(child.getMinX(), max);
                    childSecond = child;
                } else {
                    childFirst = childSplit.get(0);
                    childSecond = childSplit.get(1);
                }
            } else {
                childFirst = child;
                childSecond = new LayoutPrimitive(child.getWidth(), 0.0f);
                childSecond.moveTo(child.getMinX(), max);
            }
            if (first == null) {
                first = new LayoutContainer();
            }
            first.add(childFirst);
            if (second == null) {
                second = new LayoutContainer();
            }
            second.add(childSecond);
        }
        ArrayList<ILayoutComponent> result = new ArrayList<ILayoutComponent>();
        result.add(first);
        result.add(second);
        return result;
    }

    @Override
    public void trim() {
        this.enclose(true);
    }
}

