/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.layout;

import de.intarsys.layout.CAxis;
import de.intarsys.layout.CBorderPolicy;
import de.intarsys.layout.CDirection;
import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.LayoutContainer;
import de.intarsys.layout.RectLayouter;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class LinearLayouter
extends RectLayouter {
    private int axis = CAxis.X;
    private int borderPolicy = CBorderPolicy.FIX;
    private int direction = CDirection.ASCENDING;
    private LayoutContainer layoutContainer;

    public LinearLayouter(Rectangle2D bbox) {
        this(bbox, new LayoutContainer());
    }

    public LinearLayouter(Rectangle2D bbox, LayoutContainer layoutBox) {
        super(bbox);
        this.setLayoutContainer(layoutBox);
        this.resetContainer();
    }

    @Override
    public List<ILayoutComponent> add(ILayoutComponent element, boolean force) {
        float delta = 0.0f;
        float newX = 0.0f;
        float newY = 0.0f;
        if (this.axis == CAxis.HORIZONTAL) {
            delta = element.getWidth();
            newX = CDirection.isDescending(this.getDirection()) ? this.getLayoutContainer().getMinX() - element.getWidth() : this.getLayoutContainer().getMaxX();
            newY = this.getLayoutContainer().getMinY();
        } else {
            delta = element.getHeight();
            newX = this.getLayoutContainer().getMinX();
            newY = CDirection.isDescending(this.getDirection()) ? this.getLayoutContainer().getMinY() - element.getHeight() : this.getLayoutContainer().getMaxY();
        }
        boolean fit = this.isLayoutable(delta);
        if (fit || force) {
            element.moveTo(newX, newY);
            this.getLayoutContainer().add(element);
            if (this.getBorderPolicy() == CBorderPolicy.GROW) {
                this.getBoundingBox().add(this.getLayoutContainer().getMaxX(), this.getLayoutContainer().getMaxY());
                this.getBoundingBox().add(this.getLayoutContainer().getMinX(), this.getLayoutContainer().getMinY());
            }
            return fit ? null : new ArrayList();
        }
        ArrayList<ILayoutComponent> result = new ArrayList<ILayoutComponent>();
        result.add(element);
        return result;
    }

    @Override
    public List<ILayoutComponent> close() {
        return null;
    }

    public LinearLayouter createRemainingLayouter() {
        double x = this.getBoundingBox().getMinX();
        double y = this.getBoundingBox().getMinY();
        double w = this.getBoundingBox().getWidth();
        double h = this.getBoundingBox().getHeight();
        Rectangle2D.Double rect = this.axis == CAxis.HORIZONTAL ? (CDirection.isDescending(this.getDirection()) ? new Rectangle2D.Double(x, y, w - (double)this.getLinearPosition(), h) : new Rectangle2D.Double(x + (double)this.getLinearPosition(), y, w - (double)this.getLinearPosition(), h)) : (CDirection.isDescending(this.getDirection()) ? new Rectangle2D.Double(x, y, w, h - (double)this.getLinearPosition()) : new Rectangle2D.Double(x, y + (double)this.getLinearPosition(), w, h - (double)this.getLinearPosition()));
        LinearLayouter result = new LinearLayouter(rect);
        result.setAxis(this.getAxis());
        result.setDirection(this.getDirection());
        result.setBorderPolicy(this.getBorderPolicy());
        return result;
    }

    public int getAxis() {
        return this.axis;
    }

    public int getBorderPolicy() {
        return this.borderPolicy;
    }

    public int getDirection() {
        return this.direction;
    }

    @Override
    public LayoutContainer getLayoutContainer() {
        return this.layoutContainer;
    }

    protected float getLinearPosition() {
        return this.axis == CAxis.HORIZONTAL ? this.getLayoutContainer().getWidth() : this.getLayoutContainer().getHeight();
    }

    protected float getMax() {
        return (float)(this.axis == CAxis.HORIZONTAL ? this.getBoundingBox().getWidth() : this.getBoundingBox().getHeight());
    }

    protected boolean isLayoutable(float delta) {
        if (this.getBorderPolicy() == CBorderPolicy.GROW) {
            return true;
        }
        return this.getLinearPosition() + delta <= this.getMax();
    }

    @Override
    public void removeLast() {
        if (this.getLayoutContainer().size() == 0) {
            return;
        }
        ILayoutComponent[] components = this.getLayoutContainer().children();
        ILayoutComponent component = components[components.length - 1];
        this.getLayoutContainer().remove(component);
    }

    @Override
    protected void reset() {
        super.reset();
        this.setLayoutContainer(new LayoutContainer());
        this.resetContainer();
    }

    protected void resetContainer() {
        float bminx = (float)this.getBoundingBox().getMinX();
        float bminy = (float)this.getBoundingBox().getMinY();
        float bmaxx = (float)this.getBoundingBox().getMaxX();
        float bmaxy = (float)this.getBoundingBox().getMaxY();
        float width = this.getLayoutContainer().getWidth();
        float height = this.getLayoutContainer().getHeight();
        if (this.axis == CAxis.HORIZONTAL) {
            if (CDirection.isDescending(this.getDirection())) {
                this.getLayoutContainer().moveTo(bmaxx - width, bminy);
            } else {
                this.getLayoutContainer().moveTo(bminx, bminy);
            }
        } else if (CDirection.isDescending(this.getDirection())) {
            this.getLayoutContainer().moveTo(bminx, bmaxy - height);
        } else {
            this.getLayoutContainer().moveTo(bminx, bminy);
        }
    }

    public void setAxis(int axis) {
        this.axis = axis;
        this.resetContainer();
    }

    public void setBorderPolicy(int borderPolicy) {
        this.borderPolicy = borderPolicy;
        this.resetContainer();
    }

    public void setDirection(int direction) {
        this.direction = direction;
        this.resetContainer();
    }

    protected void setLayoutContainer(LayoutContainer newBox) {
        this.layoutContainer = newBox;
    }
}

