/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.layout;

import de.intarsys.layout.Aligner;
import de.intarsys.layout.CAlignment;
import de.intarsys.layout.CAxis;
import de.intarsys.layout.CBorderPolicy;
import de.intarsys.layout.CDirection;
import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.ILayoutContainer;
import de.intarsys.layout.LayoutContainer;
import de.intarsys.layout.LayoutPrimitive;
import de.intarsys.layout.LinearLayouter;
import de.intarsys.layout.RectLayouter;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class TextLayouter
extends RectLayouter {
    private int baseDirection = CDirection.ASCENDING;
    private LinearLayouter currentLayouter;
    private LayoutContainer currentLine;
    private int direction = CDirection.ASCENDING;
    private boolean forceFirstLine = true;
    private Stack<LinearLayouter> layouters = new Stack();
    private int linecount = 0;
    private int maxlines = -1;
    private int primaryAlignment = CAlignment.LEFT;
    private int primaryBorderPolicy = CBorderPolicy.FIX;
    private boolean replayMode = false;
    private int secondaryAlignment = CAlignment.TOP;
    private int secondaryBorderPolicy = CBorderPolicy.FIX;
    private LinearLayouter secondaryLayouter;

    public TextLayouter(Rectangle2D bbox) {
        super(bbox);
        this.pushLayouters();
        this.secondaryLayouter = new LinearLayouter(this.getBoundingBox());
        this.getSecondaryLayouter().setDirection(CDirection.DESCENDING);
        this.getSecondaryLayouter().setAxis(CAxis.VERTICAL);
        this.getSecondaryLayouter().setBorderPolicy(this.getSecondaryBorderPolicy());
    }

    @Override
    public List<ILayoutComponent> add(ILayoutComponent element, boolean force) {
        List<ILayoutComponent> result = this.getCurrentLayouter().add(element, force);
        if (result != null) {
            result = this.handlePrimaryOverflow(result);
        }
        return result;
    }

    protected List<ILayoutComponent> addLine(LayoutContainer line) {
        if (this.currentLine == null) {
            return null;
        }
        line.setFixed(true);
        List<ILayoutComponent> overflow = this.getSecondaryLayouter().add(line, false);
        if (overflow != null) {
            if (this.isForceFirstLine() && this.getSecondaryLayouter().getLayoutContainer().size() == 0) {
                this.getSecondaryLayouter().add(line, true);
                overflow = null;
            } else {
                List<ILayoutComponent> splitLine = null;
                if (this.isReplayMode() || line.getHeight() >= this.getSecondaryLayouter().getMax()) {
                    float maxHeight = this.getSecondaryLayouter().getMax() - this.getSecondaryLayouter().getLinearPosition();
                    splitLine = line.splitVertical(maxHeight, CDirection.isDescending(this.getSecondaryLayouter().getDirection()));
                }
                ArrayList<ILayoutComponent> result = new ArrayList<ILayoutComponent>();
                if (splitLine == null) {
                    for (LayoutContainer layoutContainer : overflow) {
                        result.addAll(Arrays.asList(layoutContainer.children()));
                    }
                } else {
                    LayoutContainer first = (LayoutContainer)splitLine.get(0);
                    LayoutContainer layoutContainer = (LayoutContainer)splitLine.get(1);
                    this.getSecondaryLayouter().add(first, true);
                    result.addAll(Arrays.asList(layoutContainer.children()));
                }
                overflow = result;
            }
        }
        return overflow;
    }

    @Override
    public List<ILayoutComponent> close() {
        List<ILayoutComponent> result = this.newLine(true);
        for (ILayoutComponent element : this.getSecondaryLayouter().getLayoutContainer().getChildren()) {
            Aligner aligner = ((ILayoutContainer)element).createAligner(this.getBoundingBox());
            aligner.setAxis(CAxis.HORIZONTAL);
            aligner.setAlignment(this.getPrimaryAlignment());
            aligner.setBorderPolicy(this.getPrimaryBorderPolicy());
            aligner.align(true);
        }
        Aligner aligner = this.getSecondaryLayouter().getLayoutContainer().createAligner(this.getBoundingBox());
        aligner.setAxis(CAxis.VERTICAL);
        aligner.setAlignment(this.getSecondaryAlignment());
        aligner.setBorderPolicy(this.getSecondaryBorderPolicy());
        aligner.align();
        return result;
    }

    protected LinearLayouter createLayouter(LinearLayouter previous) {
        LinearLayouter result;
        if (previous == null) {
            result = new LinearLayouter((Rectangle2D)this.getBoundingBox().clone());
            result.setAxis(CAxis.HORIZONTAL);
            result.setBorderPolicy(this.getPrimaryBorderPolicy());
            result.setDirection(this.getBaseDirection());
        } else {
            result = previous.createRemainingLayouter();
            result.setDirection(previous.getDirection() + 1);
        }
        return result;
    }

    public int getBaseDirection() {
        return this.baseDirection;
    }

    protected LinearLayouter getCurrentLayouter() {
        return this.currentLayouter;
    }

    public int getDirection() {
        return this.direction;
    }

    @Override
    public ILayoutContainer getLayoutContainer() {
        return this.getSecondaryLayouter().getLayoutContainer();
    }

    public Point2D getLayoutPosition() {
        if (this.getCurrentLayouter().getLayoutContainer().size() == 0) {
            LayoutContainer container = this.getSecondaryLayouter().getLayoutContainer();
            ILayoutComponent[] children = container.children();
            if (children.length == 0) {
                return new Point2D.Float(0.0f, 0.0f);
            }
            LayoutContainer previous = (LayoutContainer)children[children.length - 1];
            return new Point2D.Float(previous.getWidth(), container.getHeight() - previous.getHeight());
        }
        return new Point2D.Float(this.getCurrentLayouter().getLinearPosition(), this.getSecondaryLayouter().getLinearPosition());
    }

    protected int getLinecount() {
        return this.linecount;
    }

    public int getMaxlines() {
        return this.maxlines;
    }

    public int getPrimaryAlignment() {
        return this.primaryAlignment;
    }

    public int getPrimaryBorderPolicy() {
        return this.primaryBorderPolicy;
    }

    public int getSecondaryAlignment() {
        return this.secondaryAlignment;
    }

    public int getSecondaryBorderPolicy() {
        return this.secondaryBorderPolicy;
    }

    protected LinearLayouter getSecondaryLayouter() {
        return this.secondaryLayouter;
    }

    protected List<ILayoutComponent> handlePrimaryOverflow(List<ILayoutComponent> result) {
        List<ILayoutComponent> secondaryOverflow = this.newLine();
        if (secondaryOverflow == null) {
            if (this.getMaxlines() != 1) {
                ILayoutComponent lc;
                List<ILayoutComponent> forcedOverflow = null;
                Iterator<ILayoutComponent> it = result.iterator();
                while (it.hasNext()) {
                    float remainingWidth;
                    List<ILayoutComponent> split;
                    lc = it.next();
                    forcedOverflow = this.getCurrentLayouter().add(lc, false);
                    if (forcedOverflow != null && (split = lc.splitHorizontal(remainingWidth = this.getCurrentLayouter().getMax() - this.getCurrentLayouter().getLayoutContainer().getWidth())) != null) {
                        ILayoutComponent first = split.get(0);
                        ILayoutComponent second = split.get(1);
                        this.add(first, true);
                        forcedOverflow = this.add(second, false);
                    }
                    if (forcedOverflow == null) continue;
                    break;
                }
                while (it.hasNext()) {
                    lc = it.next();
                    forcedOverflow.add(lc);
                }
                result = forcedOverflow;
            }
        } else {
            secondaryOverflow.addAll(result);
            result = secondaryOverflow;
        }
        return result;
    }

    public boolean isForceFirstLine() {
        return this.forceFirstLine;
    }

    public boolean isReplayMode() {
        return this.replayMode;
    }

    public List<ILayoutComponent> newLine() {
        return this.newLine(false);
    }

    public List<ILayoutComponent> newLine(boolean paragraphEnd) {
        this.popLayoutersAll();
        List<ILayoutComponent> result = null;
        List<ILayoutComponent> secondaryOverflow = null;
        secondaryOverflow = this.getMaxlines() != -1 && this.getLinecount() == this.getMaxlines() && this.currentLine != null ? new ArrayList<ILayoutComponent>(Arrays.asList(this.currentLine.children())) : this.addLine(this.currentLine);
        if (secondaryOverflow != null) {
            result = secondaryOverflow;
        } else {
            this.setLinecount(this.getLinecount() + 1);
        }
        this.currentLine = null;
        this.currentLayouter = null;
        this.pushLayouters();
        return result;
    }

    protected void popLayouter() {
        LayoutContainer box = null;
        if (this.currentLayouter != null) {
            this.getCurrentLayouter().close();
            box = this.getCurrentLayouter().getLayoutContainer();
        }
        LinearLayouter previous = null;
        if (!this.layouters.isEmpty()) {
            previous = this.layouters.pop();
            if (box != null && box.size() > 0) {
                previous.add(box, true);
            }
            box = previous.getLayoutContainer();
        }
        this.currentLine = box;
        this.currentLayouter = previous;
    }

    protected void popLayouters() {
        do {
            this.popLayouter();
        } while (this.currentLayouter != null && this.currentLayouter.getDirection() > this.getDirection());
    }

    protected void popLayoutersAll() {
        do {
            this.popLayouter();
        } while (!this.layouters.isEmpty());
    }

    protected void pushLayouter() {
        if (this.currentLayouter != null) {
            this.layouters.push(this.currentLayouter);
        }
        this.currentLayouter = this.createLayouter(this.getCurrentLayouter());
    }

    protected void pushLayouters() {
        do {
            this.pushLayouter();
        } while (this.currentLayouter == null || this.currentLayouter.getDirection() < this.getDirection());
    }

    @Override
    public void removeLast() {
        if (this.getCurrentLayouter().getLayoutContainer().size() > 0) {
            this.getCurrentLayouter().removeLast();
        }
    }

    public void setBaseDirection(int baseDirection) {
        this.baseDirection = baseDirection;
    }

    public void setDirection(int pDirection) {
        if (this.direction == pDirection) {
            return;
        }
        int oldDirection = this.direction;
        this.direction = pDirection;
        if (oldDirection < this.direction) {
            this.pushLayouters();
        } else {
            this.popLayouters();
        }
    }

    public void setForceFirstLine(boolean b) {
        this.forceFirstLine = b;
    }

    public void setLayoutPosition(float x, float y) {
        this.newLine();
        this.add(new LayoutPrimitive(0.0f, y), true);
        this.newLine();
        this.add(new LayoutPrimitive(x, 0.0f), true);
    }

    protected void setLinecount(int currentlines) {
        this.linecount = currentlines;
    }

    public void setMaxlines(int maxlines) {
        this.maxlines = maxlines;
    }

    public void setPrimaryAlignment(int newAlignment) {
        this.primaryAlignment = newAlignment;
    }

    public void setPrimaryBorderPolicy(int primaryBorderPolicy) {
        this.primaryBorderPolicy = primaryBorderPolicy;
        this.getCurrentLayouter().setBorderPolicy(primaryBorderPolicy);
    }

    public void setReplayMode(boolean replayMode) {
        this.replayMode = replayMode;
    }

    public void setSecondaryAlignment(int newAlignment) {
        this.secondaryAlignment = newAlignment;
    }

    public void setSecondaryBorderPolicy(int secondaryBorderPolicy) {
        this.secondaryBorderPolicy = secondaryBorderPolicy;
        this.getSecondaryLayouter().setBorderPolicy(secondaryBorderPolicy);
    }
}

