/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.layout.awt;

import de.intarsys.layout.awt.LayoutElementAWT;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class LayoutString
extends LayoutElementAWT {
    private String string;

    public LayoutString(String content, FontMetrics m) {
        super(m);
        this.setString(content);
    }

    @Override
    public void drawOn(Graphics2D g) {
        int baseline = (int)this.getMinY() - this.getFontMetrics().getDescent() - this.getFontMetrics().getLeading();
        g.drawString(this.getString(), (int)this.getMinX(), baseline);
    }

    @Override
    public float getHeight() {
        return this.getFontMetrics().getHeight();
    }

    public String getString() {
        return this.string;
    }

    @Override
    public float getWidth() {
        return this.getFontMetrics().charsWidth(this.getString().toCharArray(), 0, this.getString().length());
    }

    public void setString(String newString) {
        this.string = newString;
    }

    @Override
    public String toString() {
        return this.getString();
    }
}

