/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.layout.awt;

import de.intarsys.graphic.ImagePanel;
import de.intarsys.layout.BilinearLayouter;
import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.awt.LayoutElementAWT;
import de.intarsys.layout.awt.LayoutSpace;
import de.intarsys.layout.awt.LayoutString;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TextProcessor {
    private float width;
    private float height;
    private int alignment;
    private BilinearLayouter layouter;
    private BufferedImage image;
    private Graphics2D graphics;
    private List elements = new ArrayList();

    public static void test(String text, int alignment) {
        TextProcessor p = new TextProcessor();
        p.setWidth(400.0f);
        p.setHeight(300.0f);
        p.setAlignment(alignment);
        p.open();
        p.getGraphics().setFont(new Font("Arial", 0, 40));
        p.add(text);
        p.close();
        ImagePanel.create(p.getImage());
    }

    public String add(String text) {
        StringTokenizer lines = new StringTokenizer(text, "\n", false);
        while (lines.hasMoreTokens()) {
            List overflow;
            String line = lines.nextToken();
            StringTokenizer words = new StringTokenizer(line, " \t", false);
            this.getLayouter().add(new LayoutSpace(0.0f, this.getGraphics().getFontMetrics().getHeight()), false);
            while (words.hasMoreTokens()) {
                String word = words.nextToken().trim();
                LayoutString current = new LayoutString(word, this.getGraphics().getFontMetrics());
                overflow = this.getLayouter().add(current, false);
                if (overflow != null) {
                    this.doProcessPage();
                    this.reset();
                    for (ILayoutComponent c : overflow) {
                        this.getLayouter().add(c, true);
                    }
                    this.getLayouter().add(new LayoutSpace(this.getGraphics().getFontMetrics().charWidth(' '), 0.0f), false);
                    this.getLayouter().add(current, false);
                }
                if (!words.hasMoreTokens()) continue;
                overflow = this.getLayouter().add(new LayoutSpace(this.getGraphics().getFontMetrics().charWidth(' '), 0.0f), false);
            }
            if (!lines.hasMoreTokens() || (overflow = this.getLayouter().newLine()) == null) continue;
            this.doProcessPage();
            this.reset();
        }
        return null;
    }

    public void close() {
        this.getLayouter().close();
        this.doProcessPage();
    }

    protected void doProcessPage() {
        this.getLayouter().close();
        for (ILayoutComponent element : this.elements) {
            if (!(element instanceof LayoutElementAWT)) continue;
            ((LayoutElementAWT)element).drawOn(this.getGraphics());
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public float getHeight() {
        return this.height;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public BilinearLayouter getLayouter() {
        return this.layouter;
    }

    public float getWidth() {
        return this.width;
    }

    public void open() {
        this.reset();
    }

    protected void reset() {
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight());
        this.layouter = new BilinearLayouter(rect);
        this.getLayouter().setPrimaryAlignment(this.getAlignment());
        BufferedImage i = new BufferedImage((int)this.getWidth(), (int)this.getHeight(), 1);
        this.setImage(i);
        Graphics2D g = (Graphics2D)i.getGraphics();
        this.setGraphics(g);
        g.setBackground(Color.white);
        g.setColor(Color.black);
        g.setClip(null);
        this.getGraphics().clearRect(0, 0, (int)this.getWidth(), (int)this.getHeight());
    }

    public void setAlignment(int newAlignment) {
        this.alignment = newAlignment;
    }

    public void setGraphics(Graphics2D newGraphics) {
        this.graphics = newGraphics;
    }

    public void setHeight(float newHeight) {
        this.height = newHeight;
    }

    public void setImage(BufferedImage newImage) {
        this.image = newImage;
    }

    public void setLayouter(BilinearLayouter newLayouter) {
        this.layouter = newLayouter;
    }

    public void setWidth(float newWidth) {
        this.width = newWidth;
    }
}

