/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.geometry;

import de.intarsys.tools.geometry.Dimension2D_Double;
import de.intarsys.tools.geometry.ValueSpec;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;

public class PointSpec {
    private ValueSpec x;
    private ValueSpec y;

    public static PointSpec absolute(double x, double y) {
        return new PointSpec(ValueSpec.absolute(x), ValueSpec.absolute(y));
    }

    public static PointSpec parse(String definition) {
        if (StringTools.isEmpty((String)definition)) {
            return null;
        }
        String[] split = definition.split("[xX@*]");
        if (split.length != 2) {
            throw new IllegalArgumentException("point definition requires 2 elements");
        }
        return new PointSpec(ValueSpec.parse(split[0]), ValueSpec.parse(split[1]));
    }

    public static PointSpec percent(double x, double y) {
        return new PointSpec(ValueSpec.percent(x), ValueSpec.percent(y));
    }

    public PointSpec(double x, double y) {
        this(new ValueSpec(x), new ValueSpec(y));
    }

    protected PointSpec(ValueSpec x, ValueSpec y) {
        this.x = x;
        this.y = y;
    }

    public Dimension2D getDimension(Dimension2D size) {
        return new Dimension2D_Double(this.getX(size), this.getY(size));
    }

    public Point2D getPoint(Dimension2D size) {
        return new Point2D.Double(this.getX(size), this.getY(size));
    }

    @Deprecated
    public Point2D getPoint(Point2D size) {
        return new Point2D.Double(this.x.getValue(size.getX()), this.y.getValue(size.getY()));
    }

    protected ValueSpec getX() {
        return this.x;
    }

    protected double getX(Dimension2D size) {
        return this.x.getValue(size.getWidth());
    }

    protected ValueSpec getY() {
        return this.y;
    }

    protected double getY(Dimension2D size) {
        return this.y.getValue(size.getHeight());
    }

    public String toString() {
        return this.x.toString() + "x" + this.y.toString();
    }
}

