/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.geometry;

import java.util.function.DoubleBinaryOperator;

public class ValueSpec {
    private static DoubleBinaryOperator ABSOLUTE = (spec, size) -> spec;
    private static DoubleBinaryOperator PERCENT = (spec, size) -> spec * size / 100.0;
    private DoubleBinaryOperator compute;
    private double value;

    public static ValueSpec absolute(double value) {
        return new ValueSpec(value, ABSOLUTE);
    }

    public static ValueSpec parse(String definition) {
        String valueCandidate = definition.trim();
        DoubleBinaryOperator computeCandidate = ABSOLUTE;
        if (valueCandidate.endsWith("%")) {
            computeCandidate = PERCENT;
            valueCandidate = valueCandidate.substring(0, valueCandidate.length() - 1).trim();
        }
        return new ValueSpec(Double.parseDouble(valueCandidate), computeCandidate);
    }

    public static ValueSpec percent(double value) {
        return new ValueSpec(value, PERCENT);
    }

    protected ValueSpec(double value) {
        this.value = value;
        this.compute = ABSOLUTE;
    }

    protected ValueSpec(double value, DoubleBinaryOperator compute) {
        this.value = value;
        this.compute = compute;
    }

    public double getValue() {
        return this.value;
    }

    public double getValue(double reference) {
        return this.compute.applyAsDouble(this.value, reference);
    }

    public String toString() {
        Object string = String.valueOf(this.value);
        if (this.compute == PERCENT) {
            string = (String)string + "%";
        }
        return string;
    }
}

