/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.text;

import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.TransientLocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class Text
implements INotificationSupport {
    public static final Object ATTR_VALUE = new Attribute("value");
    public static final Object ATTR_LOCATOR = new Attribute("locator");
    public static final Object ATTR_ENCODING = new Attribute("encoding");
    public static final Object ATTR_BYTES = new Attribute("bytes");
    private EventDispatcher dispatcher = new EventDispatcher((Object)this);
    private ILocator locator;
    private String encoding;
    private byte[] bytes;
    private String value;
    private boolean dirty = false;
    private boolean cachedValue = false;
    private boolean cachedBytes = false;

    public static Text createFromBytes(byte[] bytes, String encoding) {
        Text text = new Text(bytes, encoding);
        TransientLocator locator = new TransientLocator("text", "txt");
        text.setLocator((ILocator)locator);
        return text;
    }

    public static Text createFromLocator(ILocator locator) throws IOException {
        return Text.createFromLocator(locator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Text createFromLocator(ILocator locator, String encoding) throws IOException {
        InputStream is = null;
        try {
            is = locator.getInputStream();
            byte[] bytes = StreamTools.getBytes((InputStream)is);
            Text text = new Text(bytes, encoding);
            text.setLocator(locator);
            Text text2 = text;
            return text2;
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }

    public static Text createFromString(String value) {
        Text text = new Text(value);
        TransientLocator locator = new TransientLocator("text", "txt");
        text.setLocator((ILocator)locator);
        return text;
    }

    protected Text(byte[] bytes, String encoding) {
        this.value = null;
        this.encoding = encoding;
        this.bytes = bytes;
    }

    protected Text(String value) {
        this.value = value;
        this.encoding = null;
        this.bytes = null;
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            try {
                this.bytes = this.value.getBytes(this.getEncoding());
                this.cachedBytes = true;
            }
            catch (UnsupportedEncodingException e) {
                this.bytes = new byte[0];
            }
        }
        return this.bytes;
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = Charset.defaultCharset().name();
        }
        return this.encoding;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public String getValue() {
        if (this.value == null) {
            try {
                this.value = new String(this.bytes, this.getEncoding());
                this.cachedValue = true;
            }
            catch (UnsupportedEncodingException e) {
                this.value = "";
            }
        }
        return this.value;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    public void setBytes(byte[] pBytes) {
        byte[] oldValue = this.bytes;
        this.bytes = pBytes;
        this.value = null;
        this.setDirty(true);
        this.cachedBytes = false;
        this.triggerChanged(ATTR_BYTES, oldValue, this.bytes);
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setEncoding(String pEncoding) {
        String oldValue = this.encoding;
        this.encoding = pEncoding;
        if (this.cachedValue) {
            this.value = null;
        }
        if (this.cachedBytes) {
            this.bytes = null;
        }
        this.triggerChanged(ATTR_ENCODING, oldValue, this.bytes);
    }

    protected void setLocator(ILocator pLocator) {
        ILocator oldValue = this.locator;
        this.locator = pLocator;
        this.triggerChanged(ATTR_LOCATOR, oldValue, this.bytes);
    }

    public void setValue(String pValue) {
        if (this.value == null || this.value.equals(pValue)) {
            return;
        }
        String oldValue = this.value;
        this.value = pValue;
        this.bytes = null;
        this.setDirty(true);
        this.cachedValue = false;
        this.triggerChanged(ATTR_VALUE, oldValue, this.bytes);
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, attribute, oldValue, newValue);
        this.triggerEvent((Event)event);
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }
}

