/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.text;

import de.intarsys.document.common.CommonDocumentType;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.document.type.text.PACKAGE;
import de.intarsys.document.type.text.Text;
import de.intarsys.document.type.text.TextDocument;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;

public class TextDocumentType
extends CommonDocumentType<TextDocument, Text> {
    public static final String ID = TextDocumentType.class.getName();
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected TextDocument basicCreateFromImpl(ILocator locator, Object impl) {
        if (locator == null) {
            locator = this.createLocator(null);
        }
        if (impl instanceof String) {
            Text text = Text.createFromString((String)impl);
            text.setLocator(locator);
            return new TextDocument((IDocumentType)this, text);
        }
        if (impl instanceof byte[]) {
            Text text = Text.createFromBytes((byte[])impl, null);
            text.setLocator(locator);
            return new TextDocument((IDocumentType)this, text);
        }
        if (impl instanceof Text) {
            Text text = (Text)impl;
            text.setLocator(locator);
            return new TextDocument((IDocumentType)this, text);
        }
        return null;
    }

    protected TextDocument basicCreateFromLocator(ILocator locator, IArgs args) throws IOException {
        Text text = Text.createFromLocator(locator);
        return new TextDocument((IDocumentType)this, text);
    }

    protected TextDocument basicCreateNew(IArgs args) {
        Text text = Text.createFromString("");
        return new TextDocument((IDocumentType)this, text);
    }

    protected String getBaseName(Object impl) {
        return Msg.getString("TextDocument.BaseName", new Object[0]);
    }

    protected String getBaseType(Object impl) {
        return Msg.getString("TextDocument.BaseType", new Object[0]);
    }

    protected String getDefaultDefaultExtension() {
        return "txt";
    }

    protected String getDefaultDefaultMimeType() {
        return "text/plain";
    }

    public String getLabel() {
        return "Text";
    }
}

