/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.remote.http.rpc;

import de.intarsys.remote.core.AbstractRemoteCall;
import de.intarsys.remote.core.AbstractRemoteObject;
import de.intarsys.remote.core.RemoteCallConnectException;
import de.intarsys.remote.core.RemoteCallInvocationTargetException;
import de.intarsys.remote.core.RemoteCallMarshallingException;
import de.intarsys.remote.core.RemoteCallProtocolException;
import de.intarsys.remote.core.RemoteCallTimeout;
import de.intarsys.remote.core.RemoteCallUnmarshallingException;
import de.intarsys.remote.http.rpc.HttpRemoteContext;
import de.intarsys.remote.http.rpc.HttpRemoteObject;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.http.content.IHttpEntityDecoder;
import de.intarsys.tools.http.content.IHttpEntityEncoder;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.url.URLTools;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class HttpRemoteCall
extends AbstractRemoteCall {
    private static final Logger Log = LoggerFactory.getLogger(HttpRemoteCall.class);
    private static volatile int counter = 0;

    protected HttpRemoteCall(HttpRemoteObject remote, String name) {
        super((AbstractRemoteObject)remote, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object basicExecute() throws RemoteCallInvocationTargetException, RemoteCallProtocolException {
        Object object;
        int id = counter++;
        String prefixOut = ">> " + id + "|";
        String prefixIn = "<< " + id + "|";
        HttpPost requestMethod = this.createRequestMethod();
        HttpResponse response = null;
        HttpClient tempClient = this.getContext().getHttpClient();
        HttpClientContext clientContext = HttpClientContext.create();
        try {
            if (this.getRemote().isAppendMethodToArgs()) {
                this.addParameter("_name", this.getName());
            }
            IArgs newArgs = (IArgs)this.getContext().marshal(this.getArgs());
            requestMethod.setEntity(this.createEntity(newArgs));
            try {
                if (Log.isEnabledForLevel(Level.TRACE)) {
                    Log.trace("{} {} call '{}'\n{}", new Object[]{prefixOut, this.getLogLabel(), this.getName(), ArgTools.toPrintString((IArgs)newArgs, (String)prefixOut)});
                } else {
                    Log.debug("{} {} call '{}'", new Object[]{prefixOut, this.getLogLabel(), this.getName()});
                }
                response = tempClient.execute((HttpUriRequest)requestMethod, (HttpContext)clientContext);
            }
            catch (ConnectException e) {
                throw new RemoteCallConnectException(e);
            }
            catch (SocketTimeoutException e) {
                throw new RemoteCallTimeout(e);
            }
            catch (Exception e) {
                this.getContext().reset();
                throw new RemoteCallProtocolException(e.getMessage(), "Protocol-Other", (Throwable)e);
            }
            if (Log.isEnabledForLevel(Level.TRACE)) {
                List cookies = clientContext.getCookieStore().getCookies();
                for (Cookie cookie : cookies) {
                    Log.trace("{} {} call '{}' cookie {}", new Object[]{prefixIn, this.getLogLabel(), this.getName(), cookie});
                }
            }
            if (this.isError(response.getStatusLine().getStatusCode())) {
                this.handleError(response);
            }
            Object result = this.unmarshal(response);
            result = this.getContext().unmarshal(result);
            if (Log.isEnabledForLevel(Level.TRACE)) {
                Log.trace("{} {} call '{}' finished", new Object[]{prefixIn, this.getLogLabel(), this.getName()});
                if (result instanceof IArgs) {
                    Log.trace("{} {} receive \n{}", new Object[]{prefixIn, this.getLogLabel(), ArgTools.toPrintString((IArgs)((IArgs)result), (String)prefixIn)});
                }
            }
            object = result;
        }
        catch (Throwable throwable) {
            if (response != null && response.getEntity() != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    Log.info("{} call {} consume entity content failed ({})", new Object[]{this.getLogLabel(), this.getName(), ExceptionTools.getMessage((Throwable)e)});
                }
            }
            throw throwable;
        }
        if (response != null && response.getEntity() != null) {
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                Log.info("{} call {} consume entity content failed ({})", new Object[]{this.getLogLabel(), this.getName(), ExceptionTools.getMessage((Throwable)e)});
            }
        }
        return object;
    }

    protected HttpEntity createEntity(IArgs pArgs) throws RemoteCallProtocolException {
        try {
            IHttpEntityEncoder encoder = this.selectEncoder(pArgs);
            return encoder.encode((Object)pArgs);
        }
        catch (IOException e) {
            throw new RemoteCallMarshallingException((Throwable)e);
        }
    }

    protected HttpPost createRequestMethod() {
        if (this.getRemote().isAppendMethodToPath()) {
            return new HttpPost(URLTools.withTrailingSeparator((String)this.getRemote().getUrl().toString()) + this.getName());
        }
        return new HttpPost(this.getRemote().getUrl().toString());
    }

    public HttpRemoteContext getContext() {
        return (HttpRemoteContext)super.getContext();
    }

    public HttpRemoteObject getRemote() {
        return (HttpRemoteObject)super.getRemote();
    }

    protected void handleError(HttpResponse response) throws RemoteCallInvocationTargetException, RemoteCallProtocolException {
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        Log.trace("{} call {} error {} {}", new Object[]{this.getLogLabel(), this.getName(), statusCode, statusLine});
        Object result = null;
        try {
            result = this.unmarshal(response);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            String message = statusLine.toString() + "(no content)";
            throw new RemoteCallProtocolException(message, String.valueOf(statusCode));
        }
        if (result instanceof String) {
            String info = (String)result;
            if (statusCode == 500) {
                String code;
                String[] status = StringTools.getFirstLine((String)info).split("\\;", 2);
                String message = code = status[0];
                if (status.length > 1) {
                    message = status[1];
                }
                throw new RemoteCallInvocationTargetException(message, code, info);
            }
            String message = statusLine.toString() + "(" + info + ")";
            throw new RemoteCallProtocolException(message, String.valueOf(statusCode));
        }
        if (result instanceof byte[]) {
            String info = new String((byte[])result);
            String message = statusLine.toString() + "(" + info + ")";
            throw new RemoteCallProtocolException(message, String.valueOf(statusCode));
        }
        if (result instanceof Map) {
            Object error = ((Map)result).get("_error");
            if (error instanceof Map) {
                String code = String.valueOf(((Map)error).get("code"));
                String message = String.valueOf(((Map)error).get("message"));
                if (this.isClientError(statusCode)) {
                    throw new RemoteCallInvocationTargetException(message, code, "");
                }
                throw new RemoteCallProtocolException(message, code);
            }
            String message = statusLine.toString() + "(unsupported content)";
            throw new RemoteCallProtocolException(message, String.valueOf(statusCode));
        }
        String info = String.valueOf(result);
        String message = statusLine.toString() + "(" + info + ")";
        throw new RemoteCallProtocolException(message, String.valueOf(statusCode));
    }

    protected boolean isClientError(int statusCode) {
        return statusCode >= 400 && statusCode < 500;
    }

    protected boolean isError(int statusCode) {
        return statusCode >= 400;
    }

    protected boolean isServerError(int statusCode) {
        return statusCode >= 500;
    }

    protected IHttpEntityDecoder selectDecoder(Header[] headers) {
        return this.getRemote().selectDecoder(headers);
    }

    protected IHttpEntityEncoder selectEncoder(Object object) {
        return this.getRemote().selectEncoder(object);
    }

    protected Object unmarshal(HttpResponse response) throws RemoteCallProtocolException {
        IHttpEntityDecoder decoder = this.selectDecoder(response.getAllHeaders());
        HttpEntity entity = response.getEntity();
        try {
            return decoder.decode(response.getAllHeaders(), entity);
        }
        catch (IOException e) {
            throw new RemoteCallUnmarshallingException((Exception)e);
        }
    }
}

