/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.remote.http.rpc;

import de.intarsys.aaa.authenticate.api.CredentialProvider;
import de.intarsys.aaa.authenticate.api.ICredentialProvider;
import de.intarsys.remote.core.AbstractRemoteContext;
import de.intarsys.remote.core.IRemoteObject;
import de.intarsys.remote.core.RemoteCallConfigurationException;
import de.intarsys.remote.core.RemoteException;
import de.intarsys.remote.http.rpc.HttpRemoteObject;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.http.common.HttpTools;
import de.intarsys.tools.http.content.HttpEntityApplicationOctetDecoder;
import de.intarsys.tools.http.content.HttpEntityAutoEncoder;
import de.intarsys.tools.http.content.HttpEntityDecoder;
import de.intarsys.tools.http.content.IHttpEntityDecoder;
import de.intarsys.tools.http.content.IHttpEntityEncoder;
import de.intarsys.tools.http.httpcomponents.StandardHttpClientBuilder;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.locator.ClassResourceLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.ssl.ConfigurableKeyManagerProvider;
import de.intarsys.tools.ssl.ConfigurableTrustManagerProvider;
import de.intarsys.tools.ssl.IConfigurableSslContextProvider;
import de.intarsys.tools.ssl.IKeyManagerProvider;
import de.intarsys.tools.ssl.ITrustManagerProvider;
import de.intarsys.tools.ssl.SslContextProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpRemoteContext
extends AbstractRemoteContext
implements AutoCloseable {
    private static final String ATTR_TRUSTSTORE_PASSWORD = "truststorePassword";
    private static final String ATTR_TRUSTSTORE = "truststore";
    public static final String ATTR_HOST_URL = "hostUrl";
    public static final String ATTR_SSL_HOST_VERIFICATION = "sslHostVerification";
    public static final String ATTR_CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String ATTR_SOCKET_TIMEOUT = "socketTimeout";
    public static final String ARG_CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String ARG_SOCKET_TIMEOUT = "socketTimeout";
    private final Map<String, IHttpEntityDecoder> decoderRegistry = new HashMap<String, IHttpEntityDecoder>();
    private int connectionTimeout = 60000;
    private ICredentialProvider credentialProvider;
    private List<CredentialDefinition> credentials = new ArrayList<CredentialDefinition>();
    private CloseableHttpClient httpClient;
    private char[] keyPassword;
    private ILocator keyStoreLocator;
    private char[] keyStorePassword;
    private int socketTimeout = 60000;
    private boolean sslCertificateVerification = true;
    private boolean sslHostVerification = true;
    private ILocator trustStoreLocator;
    private char[] trustStorePassword;
    private IHttpEntityEncoder encoder;

    public void addCredential(String host, int port, String realm, String user, String password) {
        this.credentials.add(new CredentialDefinition(host, port, realm, user, password));
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.httpClient = null;
        }
    }

    public void configure(IElement element) throws ConfigurationException {
        this.setSslHostVerification(ElementTools.getBoolean((IElement)element, (String)ATTR_SSL_HOST_VERIFICATION, (boolean)this.isSslHostVerification()));
        int connectionTimeout = ElementTools.getInt((IElement)element, (String)"connectionTimeout", (int)this.getConnectionTimeout());
        this.setConnectionTimeout(connectionTimeout);
        int socketTimeout = ElementTools.getInt((IElement)element, (String)"socketTimeout", (int)this.getSocketTimeout());
        this.setSocketTimeout(socketTimeout);
        String truststore = ElementTools.getString((IElement)element, (String)ATTR_TRUSTSTORE, null);
        if (truststore != null) {
            ClassResourceLocator trustStoreLocator = null;
            trustStoreLocator = new ClassResourceLocator(this.getClass(), truststore);
            if (trustStoreLocator.exists()) {
                this.setTrustStoreLocator((ILocator)trustStoreLocator);
                String truststorePassword = ElementTools.getString((IElement)element, (String)ATTR_TRUSTSTORE_PASSWORD, null);
                if (truststorePassword != null) {
                    this.setTrustStorePassword(truststorePassword.toCharArray());
                }
            }
        }
    }

    protected void configureHttpClientSsl(StandardHttpClientBuilder clientBuilder) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException, UnrecoverableKeyException, GeneralSecurityException {
        Object hostnameVerifier = this.isSslHostVerification() ? new DefaultHostnameVerifier() : new NoopHostnameVerifier();
        clientBuilder.setSSLHostnameVerifier((HostnameVerifier)hostnameVerifier);
        clientBuilder.setSSLContext(this.createSSLContext());
    }

    protected CloseableHttpClient createHttpClient() throws RemoteCallConfigurationException {
        StandardHttpClientBuilder clientBuilder = new StandardHttpClientBuilder().setConnectTimeout(this.getConnectionTimeout()).setSocketTimeout(this.getSocketTimeout());
        for (CredentialDefinition credential : this.credentials) {
            clientBuilder.getCredentialsProvider().setCredentials(new AuthScope(credential.host, credential.port, credential.realm), (Credentials)new UsernamePasswordCredentials(credential.user, credential.password));
        }
        try {
            this.configureHttpClientSsl(clientBuilder);
        }
        catch (Exception e) {
            throw new RemoteCallConfigurationException(e.getMessage(), (Throwable)e);
        }
        return clientBuilder.build();
    }

    public IRemoteObject createObject(IArgs args) throws RemoteException {
        try {
            String url = ArgTools.getString((IArgs)args, (String)"de_intarsys_remote_url", null);
            return new HttpRemoteObject(this, url);
        }
        catch (MalformedURLException e) {
            throw new RemoteException((Throwable)e);
        }
    }

    protected SSLContext createSSLContext() throws GeneralSecurityException, IOException {
        IConfigurableSslContextProvider sslContextProvider = SslContextProvider.get().createProvider();
        ConfigurableKeyManagerProvider keyManagerProvider = new ConfigurableKeyManagerProvider();
        keyManagerProvider.setKeyStoreLocator(this.getKeyStoreLocator());
        keyManagerProvider.setKeyStorePassword(Secret.hide((char[])this.getKeyStorePassword()));
        keyManagerProvider.setKeyPassword(Secret.hide((char[])this.getKeyPassword()));
        sslContextProvider.setKeyManagerProvider((IKeyManagerProvider)keyManagerProvider);
        ConfigurableTrustManagerProvider trustManagerProvider = new ConfigurableTrustManagerProvider();
        trustManagerProvider.setTrustStoreLocator(this.getTrustStoreLocator());
        trustManagerProvider.setTrustAll(!this.isSslCertificateVerification());
        sslContextProvider.setTrustManagerProvider((ITrustManagerProvider)trustManagerProvider);
        return sslContextProvider.createSslContext();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public ICredentialProvider getCredentialProvider() {
        if (this.credentialProvider == null) {
            return CredentialProvider.get();
        }
        return this.credentialProvider;
    }

    public IHttpEntityEncoder getEncoder() {
        return this.encoder;
    }

    public HttpClient getHttpClient() throws RemoteCallConfigurationException {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        return this.httpClient;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public ILocator getKeyStoreLocator() {
        return this.keyStoreLocator;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public ILocator getTrustStoreLocator() {
        return this.trustStoreLocator;
    }

    public char[] getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public boolean isSslCertificateVerification() {
        return this.sslCertificateVerification;
    }

    public boolean isSslHostVerification() {
        return this.sslHostVerification;
    }

    public IHttpEntityDecoder lookupDecoder(String type) {
        return this.decoderRegistry.get(type);
    }

    public void registerDecoder(String type, IHttpEntityDecoder decoder) {
        this.decoderRegistry.put(type, decoder);
    }

    public void reset() {
        this.close();
    }

    protected IHttpEntityDecoder selectDecoder(Header[] headers) {
        String contentType = HttpTools.getContentTypeName((Header[])headers, null);
        IHttpEntityDecoder decoder = null;
        decoder = this.lookupDecoder(contentType);
        if (decoder == null) {
            decoder = HttpEntityDecoder.lookupDecoder((String)contentType);
        }
        if (decoder == null) {
            decoder = new HttpEntityApplicationOctetDecoder();
        }
        return decoder;
    }

    protected IHttpEntityEncoder selectEncoder(Object object) {
        IHttpEntityEncoder encoder = this.getEncoder();
        if (encoder == null) {
            encoder = new HttpEntityAutoEncoder();
        }
        return encoder;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setCredentialProvider(ICredentialProvider credentialsProvider) {
        this.credentialProvider = credentialsProvider;
    }

    public void setEncoder(IHttpEntityEncoder encoder) {
        this.encoder = encoder;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setKeyStoreLocator(ILocator keyStoreLocator) {
        this.keyStoreLocator = keyStoreLocator;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setSslCertificateVerification(boolean sslCertificateVerification) {
        this.sslCertificateVerification = sslCertificateVerification;
    }

    public void setSslHostVerification(boolean sslHostVerification) {
        this.sslHostVerification = sslHostVerification;
    }

    public void setTrustStoreLocator(ILocator trustStoreLocator) {
        this.trustStoreLocator = trustStoreLocator;
    }

    public void setTrustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    class CredentialDefinition {
        public String host;
        public String password;
        public int port;
        public String realm;
        public String user;

        public CredentialDefinition(String host, int port, String realm, String user, String password) {
            this.host = host;
            this.port = port;
            this.realm = realm;
            this.user = user;
            this.password = password;
        }
    }
}

