/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.remote.http.rpc;

import de.intarsys.remote.core.AbstractRemoteObject;
import de.intarsys.remote.core.IRemoteCall;
import de.intarsys.remote.core.IRemoteContext;
import de.intarsys.remote.core.RemoteCallInvocationTargetException;
import de.intarsys.remote.core.RemoteCallProtocolException;
import de.intarsys.remote.http.rpc.HttpRemoteCall;
import de.intarsys.remote.http.rpc.HttpRemoteContext;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.http.content.IHttpEntityDecoder;
import de.intarsys.tools.http.content.IHttpEntityEncoder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.Header;

public class HttpRemoteObject
extends AbstractRemoteObject {
    private final URL url;
    private boolean appendMethodToArgs = true;
    private boolean appendMethodToPath = false;

    public HttpRemoteObject(HttpRemoteContext context, String pServiceUrl) throws MalformedURLException {
        this(context, new URL(pServiceUrl));
    }

    public HttpRemoteObject(HttpRemoteContext context, String host, int port, String protocol, String path) throws MalformedURLException {
        this(context, new URL(protocol, host, port, path));
    }

    public HttpRemoteObject(HttpRemoteContext context, URL pServiceUrl) {
        super((IRemoteContext)context);
        this.url = pServiceUrl;
    }

    public void checkConnection() throws IOException {
        HttpRemoteCall call = new HttpRemoteCall(this, "_OnSystem:ping");
        try {
            call.execute();
        }
        catch (RemoteCallInvocationTargetException e) {
            throw new IOException(e);
        }
        catch (RemoteCallProtocolException e) {
            throw (IOException)ExceptionTools.getCause((Throwable)e, IOException.class);
        }
    }

    public IRemoteCall createCall(String name) {
        return new HttpRemoteCall(this, name);
    }

    public HttpRemoteContext getContext() {
        return (HttpRemoteContext)super.getContext();
    }

    public String getHost() {
        return this.url.getHost();
    }

    public String getLabel() {
        return this.getHost() + ":" + this.getPort();
    }

    public int getPort() {
        return this.url.getPort();
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isAppendMethodToArgs() {
        return this.appendMethodToArgs;
    }

    public boolean isAppendMethodToPath() {
        return this.appendMethodToPath;
    }

    protected IHttpEntityDecoder selectDecoder(Header[] headers) {
        return this.getContext().selectDecoder(headers);
    }

    protected IHttpEntityEncoder selectEncoder(Object object) {
        return this.getContext().selectEncoder(object);
    }

    public void setAppendMethodToArgs(boolean appendMethodToArgs) {
        this.appendMethodToArgs = appendMethodToArgs;
    }

    public void setAppendMethodToPath(boolean appendMethodToPath) {
        this.appendMethodToPath = appendMethodToPath;
    }

    public String toString() {
        return "HTTPRemoteObject@" + this.getUrl();
    }
}

