/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration.common;

import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.enumeration.common.EnumUnit;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import tec.units.ri.function.MultiplyConverter;
import tec.units.ri.function.RationalConverter;
import tec.units.ri.unit.MetricPrefix;
import tec.units.ri.unit.Units;

public class EnumDistanceUnit
extends EnumUnit {
    private static final Unit<Length> JAVAX_CENTIMETRE = MetricPrefix.CENTI((Unit)Units.METRE);
    private static final Unit<Length> JAVAX_INCH = MetricPrefix.CENTI((Unit)Units.METRE).transform((UnitConverter)new MultiplyConverter(2.54));
    private static final Unit<Length> JAVAX_MILLIMETRE = MetricPrefix.MILLI((Unit)Units.METRE);
    public static final Unit<Length> JAVAX_POINT = JAVAX_INCH.transform((UnitConverter)new RationalConverter(1.0, 72.0));
    public static final EnumMeta<EnumDistanceUnit> META = EnumDistanceUnit.getMeta(EnumDistanceUnit.class);
    public static final EnumDistanceUnit POINT = new EnumDistanceUnit("pt", JAVAX_POINT);
    public static final EnumDistanceUnit INCH = new EnumDistanceUnit("inch", JAVAX_INCH);
    public static final EnumDistanceUnit MM = new EnumDistanceUnit("mm", JAVAX_MILLIMETRE);
    public static final EnumDistanceUnit CM = new EnumDistanceUnit("cm", JAVAX_CENTIMETRE);

    public static EnumDistanceUnit getDistanceUnit(Unit<Length> unit) {
        if (unit.equals(JAVAX_MILLIMETRE)) {
            return MM;
        }
        if (unit.equals(JAVAX_CENTIMETRE)) {
            return CM;
        }
        if (unit.equals(JAVAX_POINT)) {
            return POINT;
        }
        if (unit.equals(JAVAX_INCH)) {
            return INCH;
        }
        return null;
    }

    protected EnumDistanceUnit(String id, Unit<Length> unit) {
        super(id, unit);
    }

    public double fromPoint(double value) {
        return POINT.convertTo(this, value);
    }

    public double toPoint(double value) {
        return this.convertTo(POINT, value);
    }

    static {
        MM.setDefault();
    }
}

