/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration.common;

import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.enumeration.common.EnumDistanceUnit;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import tec.units.ri.quantity.Quantities;
import tec.units.ri.unit.Units;

public class EnumUnit
extends EnumItem {
    public static final EnumMeta<EnumUnit> META = EnumUnit.getMeta(EnumUnit.class);
    private final Unit<?> unit;

    public static EnumUnit get(Unit<?> unit) {
        if (unit.isCompatible(Units.getInstance().getUnit(Length.class))) {
            return EnumDistanceUnit.getDistanceUnit((Unit<Length>)unit.asType(Length.class));
        }
        return null;
    }

    public EnumUnit(String id, Unit<?> unit) {
        super(id);
        this.unit = unit;
    }

    public double convertTo(EnumUnit to, double value) {
        if (to == this) {
            return value;
        }
        Quantity quantity = Quantities.getQuantity((Number)value, (Unit)this.getUnit());
        return quantity.to(to.getUnit()).getValue().doubleValue();
    }

    public Unit getUnit() {
        return this.unit;
    }
}

