/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor.jmx;

import de.intarsys.tools.monitor.AbstractMonitor;
import de.intarsys.tools.monitor.MonitorTrace;
import de.intarsys.tools.monitor.jmx.MonitorMBean;
import java.util.List;
import java.util.Map;

public class MonitorWrapper
implements MonitorMBean {
    private final AbstractMonitor monitor;

    public MonitorWrapper(AbstractMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public int getCollectAll() {
        return this.getMonitor().getCollectAll();
    }

    public AbstractMonitor getMonitor() {
        return this.monitor;
    }

    @Override
    public String getName() {
        return this.getMonitor().getName();
    }

    @Override
    public String[] getStatistics() {
        Map map = this.getMonitor().getFormattedData();
        if (map.size() == 0) {
            return new String[0];
        }
        String[] result = new String[map.size()];
        int i = 0;
        for (Map.Entry entry : this.getMonitor().getFormattedData().entrySet()) {
            result[i] = String.valueOf(entry.getKey()) + " = " + entry.getValue();
            ++i;
        }
        return result;
    }

    @Override
    public String[] getTraces() {
        List list = this.getMonitor().getTraces();
        if (list.isEmpty()) {
            return new String[0];
        }
        String[] result = new String[list.size()];
        int i = 0;
        for (MonitorTrace trace : this.getMonitor().getTraces()) {
            result[i] = trace.toString();
            ++i;
        }
        return result;
    }

    @Override
    public void reset() {
        this.getMonitor().attach();
    }

    @Override
    public void setCollectAll(int count) {
        this.getMonitor().setCollectAll(count);
    }
}

