/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.objectsession;

import de.intarsys.tools.objectsession.NestedObjectSession;
import de.intarsys.tools.objectsession.ObjectSession;
import de.intarsys.tools.transaction.ResourceException;

public abstract class ObjectSessionEntry {
    private final Object object;
    private State state = State.UNKNOWN;

    protected ObjectSessionEntry(Object object) {
        this.object = object;
    }

    public abstract void commitEntry(ObjectSession var1);

    public abstract void commitNestedEntry(NestedObjectSession var1);

    public void doChange() {
        if (this.state == State.DELETED || this.state == State.SAVED) {
            return;
        }
        this.state = State.CHANGED;
    }

    public void doDelete() {
        this.state = State.DELETED;
    }

    public void doSave() {
        this.state = State.SAVED;
    }

    public Object getObject() {
        return this.object;
    }

    public State getState() {
        return this.state;
    }

    public abstract void merge(ObjectSession var1, ObjectSessionEntry var2);

    public abstract void rollbackEntry(ObjectSession var1) throws ResourceException;

    public abstract void rollbackNestedEntry(NestedObjectSession var1) throws ResourceException;

    public abstract void rollforwardEntry(ObjectSession var1) throws ResourceException;

    public abstract void rollforwardNestedEntry(NestedObjectSession var1) throws ResourceException;

    public void setChanged() {
        this.state = State.CHANGED;
    }

    public void setDeleted() {
        this.state = State.DELETED;
    }

    public void setSaved() {
        this.state = State.SAVED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getState());
        sb.append("-");
        sb.append(this.getObject());
        return sb.toString();
    }

    protected static class State {
        public static final State SAVED = new State("saved");
        public static final State CHANGED = new State("changed");
        public static final State DELETED = new State("deleted");
        public static final State UNKNOWN = new State("unknown");
        private final String label;

        private State(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isChanged() {
            return this == CHANGED;
        }

        public boolean isDeleted() {
            return this == DELETED;
        }

        public boolean isSaved() {
            return this == SAVED;
        }

        public String toString() {
            return "[" + this.getLabel() + "]";
        }
    }
}

