/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences.common;

import de.intarsys.tools.preferences.common.LocatorPreferencesImpl;
import de.intarsys.tools.serialize.SerializationContext;
import de.intarsys.tools.serialize.xml.XMLSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PreferencesSerializer
extends XMLSerializer {
    private static final String XML_NODE = "node";
    private static final String XML_PROPERTY = "property";

    public PreferencesSerializer(SerializationContext context) {
        super(context);
    }

    public PreferencesSerializer(SerializationContext context, boolean createDocument) {
        super(context, createDocument);
    }

    protected void serialize(Object object, ContentHandler handler) throws SAXException, IOException {
        LocatorPreferencesImpl node = (LocatorPreferencesImpl)object;
        this.serializePreferences(node, handler);
    }

    protected void serializePreferences(LocatorPreferencesImpl node, ContentHandler handler) throws SAXException, IOException {
        if (node.isRemoved()) {
            return;
        }
        HashMap tempProperties = new HashMap(node.getProperties());
        ArrayList tempNodes = new ArrayList(node.getNodes());
        if (tempProperties.isEmpty() && tempNodes.isEmpty()) {
            return;
        }
        AttributesImpl attrs = new AttributesImpl();
        PreferencesSerializer.addAttribute((AttributesImpl)attrs, (String)"name", (String)node.name());
        this.doStartElement(handler, XML_NODE, attrs);
        for (Map.Entry entry : tempProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.serializeProperty(key, value, handler);
        }
        for (LocatorPreferencesImpl childNode : tempNodes) {
            this.serializePreferences(childNode, handler);
        }
        this.doEndElement(handler, XML_NODE);
    }

    protected void serializeProperty(String key, String value, ContentHandler handler) throws SAXException, IOException {
        AttributesImpl attrs = new AttributesImpl();
        PreferencesSerializer.addAttribute((AttributesImpl)attrs, (String)"name", (String)key);
        PreferencesSerializer.addAttribute((AttributesImpl)attrs, (String)"value", (String)value);
        this.doStartElement(handler, XML_PROPERTY, attrs);
        this.doEndElement(handler, XML_PROPERTY);
    }
}

