/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences.common;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesFactory;
import de.intarsys.tools.preferences.PreferencesAdapter;
import de.intarsys.tools.preferences.common.RootLocatorPreferencesImpl;
import de.intarsys.tools.preferences.common.ScopedPreferencesImpl;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PreDestroy;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopedPreferencesFactory
implements IPreferencesFactory,
IElementConfigurable {
    private static final Logger Log = LoggerFactory.getLogger(ScopedPreferencesFactory.class);
    private IPreferences root;
    private ScopedPreferencesImpl jRoot = new ScopedPreferencesImpl(null, "");
    private IPreferences main;
    private String mainName = "main";

    public ScopedPreferencesFactory() {
        RootLocatorPreferencesImpl tempJPrefs = new RootLocatorPreferencesImpl(null, "");
        this.jRoot.addScope("DEFAULT", tempJPrefs);
        this.root = new PreferencesAdapter(null, (Preferences)this.jRoot);
    }

    public void configure(IElement element) throws ConfigurationException {
        try {
            this.setMainName(element.attributeValue("main", "_default"));
            Iterator it = element.elementIterator("scope");
            while (it.hasNext()) {
                IElement child = (IElement)it.next();
                String scopeName = child.attributeValue("name", "USER");
                String fileName = child.attributeValue("path", null);
                boolean writeable = ElementTools.getBool((IElement)child, (String)"writeable", (boolean)true);
                if (fileName == null) {
                    Preferences tempPrefs = (Preferences)ElementTools.createPropertyValue((Object)this, (IElement)child, Preferences.class, null);
                    this.registerPreferences(scopeName, tempPrefs, writeable);
                    continue;
                }
                FileLocator scopeLocator = new FileLocator(fileName);
                this.registerPreferenceDirectory(scopeName, (ILocator)scopeLocator, writeable);
            }
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public synchronized IPreferences getMain() {
        if (this.main == null) {
            this.main = this.getRoot().node(this.mainName);
        }
        return this.main;
    }

    public String getMainName() {
        return this.mainName;
    }

    public synchronized IPreferences getRoot() {
        return this.root;
    }

    public List<String> getScopeNames() {
        return this.jRoot.getScopeNames();
    }

    public void registerPreferenceDirectory(String name, ILocator locator, boolean writeable) {
        RootLocatorPreferencesImpl tempJPrefs = new RootLocatorPreferencesImpl(null, "");
        tempJPrefs.setRootLocator(locator);
        this.jRoot.addScope(name, tempJPrefs, writeable);
    }

    public void registerPreferences(String name, Preferences jPrefs, boolean writeable) {
        this.jRoot.addScope(name, jPrefs, writeable);
    }

    public synchronized void setMain(IPreferences preferences) {
        this.main = preferences;
    }

    public void setMainName(String mainName) {
        this.mainName = mainName;
        this.setMain(null);
    }

    @PreDestroy
    public void uninstall() {
        try {
            this.getRoot().flush();
        }
        catch (BackingStoreException e) {
            Log.warn("can not flush preferences", (Throwable)e);
        }
    }
}

