/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.template.model;

import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.template.model.PACKAGE;
import de.intarsys.tools.template.model.TaggedStringPaletteContainer;
import de.intarsys.tools.template.model.TaggedStringPaletteNode;

public class TaggedStringPaletteExpression
extends TaggedStringPaletteNode {
    private static final String SQUARE_CLOSE = "]";
    private static final String SQUARE_OPEN = "[";
    private static IMessageBundle Msg = PACKAGE.Messages;
    private String expression;

    public TaggedStringPaletteExpression(TaggedStringPaletteContainer parent, String expr) {
        super(parent, null);
        this.expression = expr;
    }

    public TaggedStringPaletteExpression(TaggedStringPaletteContainer parent, String expr, String label) {
        super(parent, label);
        this.expression = expr;
    }

    @Override
    protected String createLabel() {
        String tempLabel = Msg.getPattern("TaggedStringPaletteExpression." + this.expression);
        if (tempLabel == null) {
            return SQUARE_OPEN + this.expression + SQUARE_CLOSE;
        }
        return SQUARE_OPEN + tempLabel + SQUARE_CLOSE;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isEditable() {
        return true;
    }

    public boolean isExpression() {
        return true;
    }

    public boolean isLiteral() {
        return false;
    }

    public void setExpression(String expr) {
        this.expression = expr;
    }

    public String toString() {
        return this.getLabel();
    }

    public String toTemplate() {
        return "${" + this.expression + "}";
    }
}

