/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.pdf;

import de.intarsys.document.type.pdf.IFieldSet;
import de.intarsys.pdf.design.widget.ExistingFieldReference;
import de.intarsys.pdf.design.widget.IFieldReference;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.attribute.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DocumentFieldSet
implements IFieldSet {
    private static final Attribute ATTR_HANDLE = new Attribute("handle");
    private PDDocument document;

    public DocumentFieldSet(PDDocument document) {
        this.document = document;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    @Override
    public IFieldReference getField(String name) {
        PDAcroForm form = this.getForm();
        if (form == null) {
            return null;
        }
        PDAcroFormField field = form.getField(name);
        if (field == null) {
            return null;
        }
        return this.getHandle(field);
    }

    @Override
    public List<IFieldReference> getFields() {
        PDAcroForm form = this.getForm();
        if (form == null) {
            return Collections.emptyList();
        }
        List fields = form.collectLeafFields();
        if (fields == null) {
            return Collections.emptyList();
        }
        ArrayList<IFieldReference> handles = new ArrayList<IFieldReference>();
        for (PDAcroFormField field : fields) {
            handles.add(this.getHandle(field));
        }
        return handles;
    }

    protected PDAcroForm getForm() {
        return this.getDocument().getAcroForm();
    }

    protected IFieldReference getHandle(PDAcroFormField field) {
        Object handle = (IFieldReference)field.getAttribute((Object)ATTR_HANDLE);
        if (handle == null) {
            handle = new ExistingFieldReference(field, null){

                public boolean equals(Object obj) {
                    return this == obj;
                }

                public String getLabel() {
                    return this.getField().getQualifiedName();
                }
            };
            field.setAttribute((Object)ATTR_HANDLE, handle);
        }
        return handle;
    }
}

