/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.pdf;

import de.intarsys.document.type.pdf.Synchpoint;
import de.intarsys.document.undo.UndoManager;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.ICOSMonitor;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.objectsession.ObjectSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentSession {
    private static final Logger Log = LoggerFactory.getLogger(DocumentSession.class);
    private static final Attribute ATTR_DOCUMENT_SESSION = new Attribute("documentSession");
    private final COSDocument doc;
    private ICOSMonitor monitor = new ICOSMonitor(){

        public void willChange(Object change) {
            DocumentSession.this.recordChange((COSObject)change);
        }
    };
    private Synchpoint synchpoint;
    private UndoManager undoManager;

    public static DocumentSession get(COSDocument doc) {
        DocumentSession result = (DocumentSession)doc.getAttribute((Object)ATTR_DOCUMENT_SESSION);
        if (result == null) {
            result = new DocumentSession(doc);
        }
        return result;
    }

    protected DocumentSession(COSDocument doc) {
        this.doc = doc;
        doc.setAttribute((Object)ATTR_DOCUMENT_SESSION, (Object)this);
        this.doc.addMonitor(this.monitor);
    }

    public COSDocument getDoc() {
        return this.doc;
    }

    protected Synchpoint getSynchpoint() {
        return this.synchpoint;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    protected void recordChange(COSObject change) {
        if (this.getSynchpoint() == null) {
            return;
        }
        try {
            this.getSynchpoint().getObjectSession().change((Object)change);
        }
        catch (ObjectSessionException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
    }

    protected void setSynchpoint(Synchpoint synchpoint) {
        this.synchpoint = synchpoint;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public Synchpoint synchpoint(Object context, String label) {
        Synchpoint tempSynchpoint = new Synchpoint(this, this.getSynchpoint(), context, label);
        this.setSynchpoint(tempSynchpoint);
        return tempSynchpoint;
    }
}

