/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.pdf;

import de.intarsys.document.common.CommonDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.document.model.IPagedDocument;
import de.intarsys.document.type.pdf.DocumentSession;
import de.intarsys.document.undo.UndoManager;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.ICOSDocumentListener;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFDocument
extends CommonDocument<PDDocument>
implements IPagedDocument<PDDocument> {
    private static final Logger Log = LoggerFactory.getLogger(PDFDocument.class);
    private ICOSDocumentListener listenDocument = new ICOSDocumentListener(){

        public void changed(COSDocument document, Object slot, Object oldValue, Object newValue) {
            PDFDocument.this.onCOSDocumentChange(slot);
        }
    };

    protected PDFDocument(IDocumentType type, PDDocument doc) {
        super(type, doc.getLocator(), (Object)doc);
        DocumentSession session = DocumentSession.get(doc.cosGetDoc());
        UndoManager undoManager = UndoManager.get((IAttributeSupport)doc);
        session.setUndoManager(undoManager);
        doc.cosGetDoc().addDocumentListener(this.listenDocument);
    }

    protected void closeImpl() {
        super.closeImpl();
        PDDocument pdDoc = (PDDocument)this.getImpl();
        pdDoc.cosGetDoc().removeDocumentListener(this.listenDocument);
        try {
            pdDoc.close();
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public String getAuthor() {
        if (this.getImpl() != null) {
            return ((PDDocument)this.getImpl()).getAuthor();
        }
        return "";
    }

    public int getPageCount() {
        return ((PDDocument)this.getImpl()).getPageTree().getCount();
    }

    public String getTitle() {
        if (this.getImpl() != null) {
            return ((PDDocument)this.getImpl()).getTitle();
        }
        return "";
    }

    public boolean isChanged() {
        return ((PDDocument)this.getImpl()).isDirty();
    }

    protected void onCOSDocumentChange(Object slot) {
        if (slot == COSDocument.SLOT_LOCATOR) {
            this.setLocator(((PDDocument)this.getImpl()).getLocator());
            this.setChanged(((PDDocument)this.getImpl()).isDirty());
        }
        if (slot == COSDocument.SLOT_DIRTY) {
            this.setChanged(((PDDocument)this.getImpl()).isDirty());
        }
        if (slot == COSDocument.SLOT_ALL) {
            this.setLocator(((PDDocument)this.getImpl()).getLocator());
            this.setChanged(((PDDocument)this.getImpl()).isDirty());
            this.triggerChangedAll();
        }
    }

    public void setAuthor(String name) {
        if (this.getImpl() != null) {
            ((PDDocument)this.getImpl()).setAuthor(name);
        }
    }

    public void setTitle(String name) {
        if (this.getImpl() != null) {
            ((PDDocument)this.getImpl()).setTitle(name);
        }
    }
}

