/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.pdf;

import de.intarsys.document.common.CommonDocumentType;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.document.type.pdf.PDFDocument;
import de.intarsys.document.type.pdf.PageProcessorTools;
import de.intarsys.pdf.app.page.EnumPageMode;
import de.intarsys.pdf.app.page.EnumRotation;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSDocumentFactory;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.ICOSDocumentFactory;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDActionGoTo;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDExplicitDestination;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageNode;
import de.intarsys.pdf.xmp.XMPStructure;
import de.intarsys.pdf.xmp.XMPStructureException;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import java.awt.geom.Point2D;
import java.io.IOException;

public class PDFDocumentType
extends CommonDocumentType<PDFDocument, PDDocument> {
    public static final String ID = PDFDocumentType.class.getName();
    public static final String ARG_PAGEMODE = "pageMode";
    public static final String ARG_ZOOM = "zoom";
    public static final String ARG_GOTOPAGE = "gotoPage";
    private static final Object ATTR_DOCUMENT = new Object();

    protected static void forceClose(COSDocument cosDoc) {
        if (cosDoc == null) {
            return;
        }
        try {
            cosDoc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addExplicitDestination(IArgs args, PDDocument doc, PDActionGoTo action) {
        int pageIndex = this.getGoToPage(args);
        PDPage page = doc.getPageTree().getPageAt(pageIndex);
        if (page == null) {
            return;
        }
        String modeID = this.getZoom(args);
        COSArray destination = COSArray.create();
        destination.add(page.cosGetObject());
        COSFixed posLeft = COSFixed.create((float)0.0f);
        COSFixed posTop = COSFixed.create((float)page.getMediaBox().getHeight());
        if (modeID.equals("fitPage") || modeID.equals("Fit")) {
            destination.add((COSObject)PDExplicitDestination.CN_DISPLAY_MODE_Fit);
        } else if (modeID.equals("fitPageHorizontal") || modeID.equals("FitH")) {
            destination.add((COSObject)PDExplicitDestination.CN_DISPLAY_MODE_FitH);
            destination.add((COSObject)posTop);
        } else if (modeID.equals("fitPageVertical") || modeID.equals("FitV")) {
            destination.add((COSObject)PDExplicitDestination.CN_DISPLAY_MODE_FitV);
            destination.add((COSObject)posTop);
        } else if (modeID.equals("original") || modeID.equals("XYZ")) {
            destination.add((COSObject)PDExplicitDestination.CN_DISPLAY_MODE_XYZ);
            destination.add((COSObject)posLeft);
            destination.add((COSObject)posTop);
            destination.add((COSObject)COSFixed.create((float)1.0f));
        } else {
            destination.add((COSObject)PDExplicitDestination.CN_DISPLAY_MODE_XYZ);
            destination.add((COSObject)posLeft);
            destination.add((COSObject)posTop);
            destination.add((COSObject)COSFixed.create((float)0.0f));
        }
        action.cosGetDict().put(PDActionGoTo.DK_D, (COSObject)destination);
    }

    protected PDFDocument basicCreateFromImpl(ILocator locator, Object impl) {
        if (impl instanceof PDDocument) {
            return new PDFDocument((IDocumentType)this, (PDDocument)impl);
        }
        if (impl instanceof COSDocument) {
            return new PDFDocument((IDocumentType)this, PDDocument.createFromCos((COSDocument)((COSDocument)impl)));
        }
        return null;
    }

    protected PDFDocument basicCreateFromLocator(ILocator locator, IArgs args) throws IOException {
        COSDocument cosDoc = null;
        try {
            ICOSDocumentFactory cosFactory = COSDocumentFactory.get();
            cosDoc = cosFactory.createDocument(locator, ArgTools.toMap((IArgs)args));
            PDDocument pddoc = PDDocument.createFromCos((COSDocument)cosDoc);
            pddoc.getCatalog();
            XMPStructure.createFromCos((COSDocument)pddoc.cosGetDoc());
            PDFDocument idoc = (PDFDocument)((Object)pddoc.getAttribute(ATTR_DOCUMENT));
            if (idoc == null) {
                idoc = new PDFDocument((IDocumentType)this, pddoc);
                pddoc.setAttribute(ATTR_DOCUMENT, (Object)idoc);
            }
            return idoc;
        }
        catch (IOException e) {
            PDFDocumentType.forceClose(cosDoc);
            throw e;
        }
        catch (Exception e) {
            PDFDocumentType.forceClose(cosDoc);
            throw new IOException("Error reading document (" + e.getMessage() + ")", e);
        }
    }

    protected PDFDocument basicCreateNew(IArgs args) {
        PDDocument pdDoc = PDDocument.createNew();
        XMPStructure xmp = XMPStructure.createFromCos((COSDocument)pdDoc.cosGetDoc());
        pdDoc.setCreator(this.computeCreator());
        try {
            xmp.persist();
        }
        catch (XMPStructureException xMPStructureException) {
            // empty catch block
        }
        pdDoc.getCatalog().setPageMode(this.getPageMode(args).getId());
        EnumRotation rotation = this.getRotation(args);
        if (rotation.getDegrees() != 0) {
            pdDoc.getPageTree().setRotate(rotation.getDegrees());
        }
        for (int i = 0; i < this.getPageCount(args); ++i) {
            PDPage newPage = (PDPage)PDPage.META.createNew();
            Point2D pageSize = PageProcessorTools.getPageSize(args);
            newPage.setMediaBox(new CDSRectangle(0.0f, 0.0f, (float)((int)pageSize.getX()), (float)((int)pageSize.getY())));
            pdDoc.getPageTree().addNode((PDPageNode)newPage);
        }
        if (this.getGoToPage(args) < this.getPageCount(args) && this.getGoToPage(args) > 0 || !this.getZoom(args).equals("current")) {
            PDActionGoTo actionGoTo = (PDActionGoTo)PDActionGoTo.META.createNew();
            this.addExplicitDestination(args, pdDoc, actionGoTo);
            pdDoc.setOpenAction((PDAction)actionGoTo);
        }
        return new PDFDocument((IDocumentType)this, pdDoc);
    }

    private String computeCreator() {
        String template = "${app.name} ${app.major}.${app.minor}";
        try {
            return (String)TemplateEvaluator.get((Mode)Mode.UNTRUSTED).evaluate(template, (IArgs)Args.create());
        }
        catch (EvaluationException e) {
            return "intarsys PDF tools";
        }
    }

    protected String getBaseName(Object impl) {
        return "New PDF Document";
    }

    protected String getBaseType(Object impl) {
        return "pdf";
    }

    protected String getDefaultDefaultExtension() {
        return "pdf";
    }

    protected String getDefaultDefaultMimeType() {
        return "application/pdf";
    }

    protected int getGoToPage(IArgs args) {
        return ArgTools.getInt((IArgs)args, (String)ARG_GOTOPAGE, (int)1);
    }

    public String getLabel() {
        return "PDF";
    }

    protected int getPageCount(IArgs args) {
        return ArgTools.getInt((IArgs)args, (String)"pageCount", (int)1);
    }

    protected EnumPageMode getPageMode(IArgs args) {
        return (EnumPageMode)ArgTools.getEnumItemStrict((IArgs)args, (EnumMeta)EnumPageMode.META, (String)ARG_PAGEMODE);
    }

    protected EnumRotation getRotation(IArgs args) {
        EnumRotation rotation = (EnumRotation)EnumRotation.META.getItemOrDefault("" + ArgTools.getInt((IArgs)args, (String)"pageRotation", (int)0));
        return rotation;
    }

    protected String getZoom(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)ARG_ZOOM, (String)"current");
    }
}

