/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.pdf;

import de.intarsys.document.common.CommonSaveFunctor;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.undo.UndoManager;
import de.intarsys.pdf.app.action.ActionTools;
import de.intarsys.pdf.app.action.TriggerEvent;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.st.EnumWriteMode;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorExecutionException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.util.HashMap;

public class PDFSaveFunctor
extends CommonSaveFunctor {
    protected Object basicSave(IDocument document, ILocator locator, IArgs args) throws FunctorException {
        PDDocument doc = (PDDocument)document.getImpl();
        try {
            this.triggerWillSave(doc);
            HashMap<String, EnumWriteMode> options = new HashMap<String, EnumWriteMode>();
            options.put("writeModeHint", doc.getWriteModeHint());
            doc.save(locator, options);
            UndoManager undoManager = UndoManager.get((IAttributeSupport)document);
            if (undoManager != null) {
                undoManager.clear();
            }
            this.triggerDidSave(doc);
            return document;
        }
        catch (IOException e) {
            throw new FunctorExecutionException((Throwable)e);
        }
    }

    protected TriggerEvent triggerDidSave(PDDocument pddoc) {
        return ActionTools.documentTriggerDidSave((PDDocument)pddoc);
    }

    protected TriggerEvent triggerWillSave(PDDocument pddoc) {
        return ActionTools.documentTriggerWillSave((PDDocument)pddoc);
    }
}

