/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.pdf;

import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pdf.IRangeContextFactory;
import de.intarsys.document.type.pdf.PACKAGE;
import de.intarsys.pdf.app.page.EnumPageSize;
import de.intarsys.pdf.app.page.PageSelector;
import de.intarsys.pdf.app.page.PageTools;
import de.intarsys.pdf.design.markup.ExistingAnnotationReference;
import de.intarsys.pdf.design.markup.IMarkupReference;
import de.intarsys.pdf.design.markup.NewAnnotationReference;
import de.intarsys.pdf.design.widget.ExistingFieldReference;
import de.intarsys.pdf.design.widget.IFieldReference;
import de.intarsys.pdf.design.widget.NewFieldReference;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.tools.kernel.PDFColorTools;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.enumeration.common.EnumAlignment;
import de.intarsys.tools.enumeration.common.EnumDistanceUnit;
import de.intarsys.tools.enumeration.common.IAlignment;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.number.NumberParser;
import de.intarsys.tools.number.NumberWrapper;
import de.intarsys.tools.range.IRangeContext;
import de.intarsys.tools.range.LiteralRangeContext;
import de.intarsys.tools.reporter.Reporter;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PageProcessorTools {
    public static final String ARG_BEFOREAFTER = "beforeAfter";
    private static final String ARG_CREATEONLY = "createOnly";
    public static final String ARG_DESTINATIONDOCUMENT = "destinationDocument";
    public static final String ARG_DOCUMENT = "document";
    @Deprecated
    public static final String ARG_PAGE = "page";
    public static final String ARG_PAGECOUNT = "pageCount";
    @Deprecated
    public static final String ARG_PAGERANGE = "pageRange";
    @Deprecated
    public static final String ARG_PAGERANGECONTEXT = "pageRangeContext";
    public static final String ARG_PAGEROTATION = "pageRotation";
    @Deprecated
    public static final String ARG_PAGESIZE = "pageSize";
    public static final String ARG_POSITION = "position";
    public static final String ARG_ROTATE = "rotate";
    public static final String ARG_SIZE = "size";
    public static final String ARG_SOURCEDOCUMENT = "sourceDocument";
    public static final String ARG_STAMPNAME = "stampName";
    public static final String ARG_SUBTYPE = "subType";
    public static final String ARG_UNIQUENAME = "uniqueName";
    public static final String ARG_VISIBLE = "visible";
    public static final String DEFAULT_PAGERANGEVALUE = "0";
    public static final IMessageBundle Msg = PACKAGE.Messages;
    public static final String PREFIX_DOCUMENT = "document";
    public static final String PREFIX_SOURCEDOCUMENT = "sourceDocument";
    public static final String VALUE_BEFOREAFTER_AFTER = "after";
    public static final String VALUE_BEFOREAFTER_BEFORE = "before";
    public static final String VALUE_PAGE_CURRENT = "current";
    public static final String VALUE_PAGE_FIRST = "first";
    public static final String VALUE_PAGE_LAST = "last";
    public static final String VALUE_PAGERANGE_ALL = "all";
    public static final String VALUE_PAGERANGE_CURRENT = "current";
    public static final String VALUE_PAGERANGE_FIRST = "first";
    public static final String VALUE_PAGERANGE_LAST = "last";
    public static final String DEFAULT_BEFOREAFTER = "after";
    public static final String DEFAULT_PAGE = "last";
    public static final String DEFAULT_PAGERANGE = "all";

    public static String convertBase0to1(String pageRange) {
        try {
            NumberWrapper wrapper = NumberParser.parseInteger((String)pageRange.trim());
            wrapper.increment(1);
            return wrapper.toString();
        }
        catch (IOException e) {
            return "1";
        }
    }

    public static String convertBase1to0(String pageRange) {
        try {
            NumberWrapper wrapper = NumberParser.parseInteger((String)pageRange.trim());
            wrapper.increment(-1);
            return wrapper.toString();
        }
        catch (IOException e) {
            return DEFAULT_PAGERANGEVALUE;
        }
    }

    public static IRangeContext createRangeContext(IDocument<?> document) {
        IRangeContextFactory contextFactory = (IRangeContextFactory)AdapterTools.getAdapter(document, IRangeContextFactory.class, null);
        if (contextFactory == null) {
            return null;
        }
        return contextFactory.createRangeContext(document);
    }

    public static IFieldReference getFieldReference(IArgs args, String name, PDDocument doc, IRangeContext rangeContext, Map overrideMap) throws ConversionException {
        if (args == null) {
            return null;
        }
        Object argValue = args.get(name);
        if (argValue == null) {
            return null;
        }
        if (argValue instanceof IFieldReference) {
            if (doc != null) {
                return ((IFieldReference)argValue).createInContext(doc);
            }
            return (IFieldReference)argValue;
        }
        if (argValue instanceof String) {
            if (StringTools.isEmpty((String)((String)argValue))) {
                return null;
            }
            argValue = Converter.asMap((String)((String)argValue));
        }
        if (argValue instanceof IArgs) {
            argValue = ArgTools.toMap((IArgs)((IArgs)argValue));
        }
        if (argValue instanceof Map) {
            ExistingFieldReference ref;
            Map argMap = (Map)argValue;
            if (overrideMap != null) {
                argMap.putAll(overrideMap);
            }
            Args nestedArgs = new Args(argMap);
            String fieldName = ArgTools.getString((IArgs)nestedArgs, (String)"name", null);
            boolean createOnly = ArgTools.getBoolStrict((IArgs)nestedArgs, (String)ARG_CREATEONLY, (boolean)false);
            boolean create = ArgTools.getBoolStrict((IArgs)nestedArgs, (String)"create", (boolean)StringTools.isEmpty((String)fieldName));
            if (create) {
                String fieldType = ArgTools.getString((IArgs)nestedArgs, (String)"fieldType", (String)PDAcroFormField.CN_FT_Sig.stringValue());
                NewFieldReference newRef = new NewFieldReference(doc, fieldType);
                ref = newRef;
                boolean fieldVisible = ArgTools.getBoolStrict((IArgs)nestedArgs, (String)ARG_VISIBLE, (boolean)true);
                newRef.setVisible(fieldVisible);
                if (fieldVisible) {
                    PageProcessorTools.validateRotate(nestedArgs);
                    PageProcessorTools.initFieldReferenceFont(nestedArgs, newRef);
                    PageProcessorTools.initFieldReferenceGeometry(nestedArgs, newRef);
                    PageProcessorTools.initFieldReferencePosition(nestedArgs, newRef);
                    PageProcessorTools.initFieldReferenceSize((IArgs)nestedArgs, newRef);
                    PageProcessorTools.initFieldReferenceAlignment(nestedArgs, newRef);
                }
                PageProcessorTools.initFieldReferencePageRange((IArgs)nestedArgs, newRef, rangeContext);
            } else {
                if (createOnly) {
                    return null;
                }
                ref = new ExistingFieldReference(doc);
            }
            String uniqueName = ArgTools.getString((IArgs)nestedArgs, (String)ARG_UNIQUENAME, null);
            ref.setUniqueName(uniqueName);
            ref.setAttributes(argMap);
            args.put(name, (Object)ref);
            return ref;
        }
        return null;
    }

    public static IMarkupReference getMarkupReference(IArgs args, String name, IMarkupReference defaultValue, PDDocument doc, IRangeContext rangeContext, Map defaultMap, Map overrideMap) {
        if (args == null) {
            return defaultValue;
        }
        Object argValue = args.get(name);
        if (argValue == null) {
            return defaultValue;
        }
        if (argValue instanceof IMarkupReference) {
            return (IMarkupReference)argValue;
        }
        if (argValue instanceof IArgs) {
            argValue = ArgTools.toMap((IArgs)((IArgs)argValue));
        }
        if (argValue instanceof Map) {
            ExistingAnnotationReference ref;
            boolean create;
            Map argMap = (Map)argValue;
            if (overrideMap != null) {
                argMap.putAll(overrideMap);
            }
            Args nestedArgs = new Args(argMap);
            if (defaultMap != null) {
                ArgTools.putAllIfAbsent((IArgs)nestedArgs, (Map)defaultMap);
            }
            if (create = ArgTools.getBoolStrict((IArgs)nestedArgs, (String)"create", (boolean)false)) {
                String subType = ArgTools.getString((IArgs)nestedArgs, (String)ARG_SUBTYPE, (String)"Stamp");
                NewAnnotationReference newRef = new NewAnnotationReference(doc, subType);
                ref = newRef;
                EnumDistanceUnit unit = (EnumDistanceUnit)ArgTools.getEnumItem((IArgs)nestedArgs, (EnumMeta)EnumDistanceUnit.META, (String)"unit", (EnumItem)EnumDistanceUnit.POINT);
                newRef.setDistanceUnit(unit);
                Point2D fieldPosition = ArgTools.getPoint((IArgs)nestedArgs, (String)ARG_POSITION, null);
                newRef.setPositionScaled(fieldPosition);
                Point2D fieldSize = ArgTools.getPoint((IArgs)nestedArgs, (String)ARG_SIZE, null);
                newRef.setSizeScaled(fieldSize);
                boolean fieldVisible = ArgTools.getBoolStrict((IArgs)nestedArgs, (String)ARG_VISIBLE, (boolean)true);
                newRef.setVisible(fieldVisible);
                PageSelector pageSelector = PageProcessorTools.getPageSelector((IArgs)nestedArgs, rangeContext);
                newRef.setPageSelector(pageSelector);
            } else {
                ref = new ExistingAnnotationReference(doc);
            }
            String uniqueName = ArgTools.getString((IArgs)nestedArgs, (String)ARG_UNIQUENAME, null);
            ref.setUniqueName(uniqueName);
            ref.setAttributes(argMap);
            return ref;
        }
        return null;
    }

    @Deprecated
    public static List<PDPage> getPageRange(IArgs args, String prefix, PDDocument doc) {
        String pageRange = "all";
        String optionName = ArgTools.prefix((String)prefix, (String)ARG_PAGERANGE);
        if (args.get(optionName) != null) {
            pageRange = (String)args.get(optionName);
        }
        ArrayList<PDPage> pages = new ArrayList<PDPage>();
        if (StringTools.isNumeric((String)pageRange)) {
            try {
                int pageCount = doc.getPageTree().getCount();
                NumberWrapper wrapper = NumberParser.parseInteger((String)pageRange.trim());
                for (Number number : wrapper) {
                    PDPage page;
                    int index = number.intValue();
                    if (index < 0 || index >= pageCount || (page = doc.getPageTree().getPageAt(index)) == null) continue;
                    pages.add(page);
                }
                return pages;
            }
            catch (Exception e) {
                Reporter.get().reportMessage(Msg.getString("PageProcessorTools.Error", new Object[0]), Msg.getString("PageProcessorTools.ErrorImportingDocument", new Object[]{e.getMessage()}), 0);
                return pages;
            }
        }
        if (pageRange.equals("first")) {
            PDPage page = doc.getPageTree().getFirstPage();
            pages.add(page);
            return pages;
        }
        if (pageRange.equals("last")) {
            PDPage page = doc.getPageTree().getLastPage();
            pages.add(page);
            return pages;
        }
        for (PDPage page = doc.getPageTree().getFirstPage(); page != null; page = page.getNextPage()) {
            pages.add(page);
        }
        return pages;
    }

    public static List<Integer> getPageRangeIndices(IArgs args, String prefix) {
        String pageRange = "all";
        int pageCount = 1;
        String optionName = ArgTools.prefix((String)prefix, (String)ARG_PAGERANGE);
        if (args.get(optionName) != null) {
            pageRange = (String)args.get(optionName);
        }
        if (args.get(optionName = ArgTools.prefix((String)prefix, (String)ARG_PAGECOUNT)) != null) {
            pageCount = Integer.valueOf(args.get(optionName).toString());
        }
        ArrayList<Integer> pages = new ArrayList<Integer>();
        if (StringTools.isNumeric((String)pageRange)) {
            try {
                NumberWrapper wrapper = NumberParser.parseInteger((String)pageRange.trim());
                for (Number number : wrapper) {
                    int index = number.intValue();
                    if (index < 0 || index >= pageCount) continue;
                    pages.add(index);
                }
                return pages;
            }
            catch (Exception e) {
                Reporter.get().reportMessage(Msg.getString("PageProcessorTools.Error", new Object[0]), Msg.getString("PageProcessorTools.ErrorImportingDocument", new Object[]{e.getMessage()}), 0);
                return pages;
            }
        }
        if (pageRange.equals("first")) {
            pages.add(Integer.valueOf(DEFAULT_PAGERANGEVALUE));
            return pages;
        }
        if (pageRange.equals("last")) {
            pages.add(pageCount - 1);
            return pages;
        }
        for (int i = 0; i < pageCount - 1; ++i) {
            pages.add(i);
        }
        return pages;
    }

    @Deprecated
    public static PageSelector getPageSelector(IArgs args, IRangeContext pRangeContext) {
        return PageTools.getPageSelector((IArgs)args, (IRangeContext)pRangeContext);
    }

    @Deprecated
    public static Point2D getPageSize(IArgs args) {
        String pageSizeString = ArgTools.getString((IArgs)args, (String)ARG_PAGESIZE, (String)EnumPageSize.META.getDefault().getId()).trim();
        if (StringTools.isNumeric((String)pageSizeString)) {
            return ArgTools.getPoint((IArgs)args, (String)ARG_PAGESIZE, null);
        }
        EnumPageSize pageSize = (EnumPageSize)EnumPageSize.META.getItemOrDefault(pageSizeString);
        return new Point2D.Float(pageSize.getWidth(), pageSize.getHeight());
    }

    @Deprecated
    public static int getPageValue(IArgs args, String prefix, int numberOfPages) {
        String beforeAfter = "after";
        String page = "last";
        String optionName = ArgTools.prefix((String)prefix, (String)ARG_BEFOREAFTER);
        if (args.get(optionName) != null) {
            beforeAfter = (String)args.get(optionName);
        }
        if (args.get(optionName = ArgTools.prefix((String)prefix, (String)ARG_PAGE)) != null) {
            page = (String)args.get(optionName);
        }
        int pageNumber = 0;
        if (StringTools.isNumeric((String)page)) {
            try {
                pageNumber = Integer.parseInt(page.trim());
            }
            catch (NumberFormatException e) {
                pageNumber = numberOfPages - 1;
            }
        } else {
            pageNumber = page.equals("first") ? 0 : (page.equals("last") ? numberOfPages - 1 : numberOfPages - 1);
        }
        if (VALUE_BEFOREAFTER_BEFORE.equals(beforeAfter)) {
            --pageNumber;
        }
        return pageNumber;
    }

    public static IRangeContext getRangeContext(IArgs args, String name) {
        Object value = args.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof IRangeContext) {
            return (IRangeContext)value;
        }
        IArgs argsValue = ArgTools.toArgs((Object)value);
        return new LiteralRangeContext(argsValue);
    }

    protected static void initFieldReferenceAlignment(Args nestedArgs, NewFieldReference newRef) {
        EnumAlignment fieldHalign = EnumAlignment.createFromArgs((IArgs)nestedArgs, (String)"hAlign", (IAlignment)EnumAlignment.START);
        newRef.setHAlign(fieldHalign);
        EnumAlignment fieldValign = EnumAlignment.createFromArgs((IArgs)nestedArgs, (String)"vAlign", (IAlignment)EnumAlignment.START);
        newRef.setVAlign(fieldValign);
    }

    protected static void initFieldReferenceFont(Args args, NewFieldReference fieldReference) {
        IArgs fontArgs = ArgTools.getArgs((IArgs)args, (String)"font", null);
        if (fontArgs == null) {
            return;
        }
        String fontName = ArgTools.getString((IArgs)fontArgs, (String)"fontName", null);
        if (fontName != null) {
            fieldReference.getFontInfo().setFontName(fontName);
        }
        fieldReference.getFontInfo().setFontSize(ArgTools.getFloatStrict((IArgs)fontArgs, (String)"fontSize", (float)-1.0f));
        String fontColor = ArgTools.getString((IArgs)fontArgs, (String)"fontColor", null);
        fieldReference.getFontInfo().setFontColor(PDFColorTools.parse((String)fontColor));
    }

    protected static void initFieldReferenceGeometry(Args args, NewFieldReference newRef) {
        EnumDistanceUnit unit = (EnumDistanceUnit)ArgTools.getEnumItem((IArgs)args, (EnumMeta)EnumDistanceUnit.META, (String)"unit", (EnumItem)EnumDistanceUnit.POINT);
        newRef.setDistanceUnit(unit);
        newRef.setAdjustForRotate(ArgTools.getBoolStrict((IArgs)args, (String)"adjustForRotate", (boolean)false));
    }

    protected static void initFieldReferencePageRange(IArgs args, NewFieldReference fieldReference, IRangeContext rangeContext) throws ConversionException {
        PageSelector pageSelector = PageProcessorTools.getPageSelector(args, rangeContext);
        PDDocument document = fieldReference.getDocument();
        if (document != null && !pageSelector.getPages(document).hasNext()) {
            throw new ConversionException("invalid page range for field creation");
        }
        fieldReference.setPageSelector(pageSelector);
    }

    protected static void initFieldReferencePosition(Args args, NewFieldReference fieldReference) throws ConversionException {
        Object value = ArgTools.getPath((IArgs)args, (String)ARG_POSITION);
        Point2D point = ArgTools.getPoint((IArgs)args, (String)ARG_POSITION, null);
        if (!(point != null || value == null || value instanceof String && ((String)value).length() == 0)) {
            throw new ConversionException("invalid position for field creation");
        }
        fieldReference.setPositionScaled(point);
    }

    protected static void initFieldReferenceSize(IArgs args, NewFieldReference fieldReference) throws ConversionException {
        Object value = ArgTools.getPath((IArgs)args, (String)ARG_SIZE);
        Point2D point = ArgTools.getPoint((IArgs)args, (String)ARG_SIZE, null);
        if (!(point != null || value == null || value instanceof String && ((String)value).length() == 0)) {
            throw new ConversionException("invalid size for field creation");
        }
        fieldReference.setSizeScaled(point);
    }

    protected static void validateRotate(Args args) throws ConversionException {
        int rotate = ArgTools.getInt((IArgs)args, (String)ARG_ROTATE, (int)0);
        if (rotate % 90 != 0 && rotate % 90 != 0) {
            throw new ConversionException("invalid rotate value for field creation");
        }
    }

    private PageProcessorTools() {
    }
}

