/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.pdf;

import de.intarsys.document.location.ILocation;
import de.intarsys.document.location.ILocationSupport;
import de.intarsys.document.type.pdf.DocumentSession;
import de.intarsys.document.type.pdf.DocumentSessionUndoAction;
import de.intarsys.document.undo.IUndoAction;
import de.intarsys.document.undo.UndoManager;
import de.intarsys.tools.objectsession.ObjectSession;
import de.intarsys.tools.objectsession.ObjectSessionType;
import de.intarsys.tools.transaction.ResourceException;

public class Synchpoint {
    private static final int ROLLFORWARD = 0;
    private static final int ROLLBACK = 1;
    private DocumentSession documentSession;
    private Synchpoint next;
    private Synchpoint prev;
    private int state = 0;
    private ObjectSession objectSession;

    public Synchpoint(DocumentSession documentSession, Synchpoint prev, Object context, String label) {
        this.documentSession = documentSession;
        this.prev = prev;
        if (prev != null) {
            prev.setNext(this);
        }
        this.objectSession = ObjectSessionType.get().createResource(null);
        DocumentSessionUndoAction undo = new DocumentSessionUndoAction(this);
        if (context instanceof ILocationSupport) {
            ILocation location = ((ILocationSupport)context).createLocation();
            undo.setLocation(location);
        }
        undo.setLabel(label);
        if (this.getUndoManager() != null) {
            this.getUndoManager().pushUndo((IUndoAction)undo);
        }
    }

    protected void basicRollback() {
        if (this.state == 1) {
            return;
        }
        if (this.getNext() != null) {
            this.getNext().basicRollback();
        }
        this.getDocumentSession().setSynchpoint(this.getPrev());
        try {
            this.objectSession.rollback();
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        this.state = 1;
    }

    protected void basicRollforward() {
        if (this.state == 0) {
            return;
        }
        if (this.getPrev() != null) {
            this.getPrev().basicRollforward();
        }
        this.getDocumentSession().setSynchpoint(this);
        try {
            this.objectSession.rollforward();
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        this.state = 0;
    }

    protected DocumentSession getDocumentSession() {
        return this.documentSession;
    }

    protected Synchpoint getNext() {
        return this.next;
    }

    protected ObjectSession getObjectSession() {
        return this.objectSession;
    }

    protected Synchpoint getPrev() {
        return this.prev;
    }

    protected UndoManager getUndoManager() {
        return this.getDocumentSession().getUndoManager();
    }

    public void rollback() {
        if (this.state == 1) {
            return;
        }
        if (this.getNext() != null) {
            this.getNext().rollback();
        }
        if (this.getUndoManager() != null) {
            IUndoAction pop = this.getUndoManager().popUndo();
            while (pop != null) {
                pop.undo();
                pop = this.getUndoManager().popUndo();
            }
        }
        this.basicRollback();
    }

    public void rollforward() {
        if (this.state == 0) {
            return;
        }
        if (this.getPrev() != null) {
            this.getPrev().rollforward();
        }
        this.basicRollforward();
    }

    protected void setNext(Synchpoint next) {
        this.next = next;
    }
}

