/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.xmp;

import de.intarsys.pdf.app.observer.COSAspectWatchdog;
import de.intarsys.pdf.app.observer.COSStructureWatchdog;
import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSInfoDict;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.xmp.XMPStructureException;
import de.intarsys.tools.attribute.Attribute;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.XMPSchemaBasic;
import org.jempbox.xmp.XMPSchemaDublinCore;
import org.jempbox.xmp.XMPSchemaPDF;
import org.jempbox.xmp.pdfa.XMPMetadataPDFA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMPStructure {
    private static final Logger Log = LoggerFactory.getLogger(XMPStructure.class);
    private static final Attribute ATTR_XMP_STRUCTURE = new Attribute("xmpstructure");
    private static final COSName CN_Metadata = COSName.constant((String)"Metadata");
    private static final COSName CN_XML = COSName.constant((String)"XML");
    private COSDocument cosDocument;
    private XMPWatchdog watchdog;
    private XMPMetadata xmpMetadata;
    private boolean persisting;

    public static XMPStructure createFromCos(COSDocument cosDoc) {
        XMPStructure xmpStructure = (XMPStructure)cosDoc.getAttribute((Object)ATTR_XMP_STRUCTURE);
        if (xmpStructure == null) {
            xmpStructure = new XMPStructure(cosDoc);
            cosDoc.setAttribute((Object)ATTR_XMP_STRUCTURE, (Object)xmpStructure);
        }
        return xmpStructure;
    }

    protected XMPStructure(COSDocument cosDocument) {
        this.cosDocument = cosDocument;
        try {
            this.watchdog = new XMPWatchdog(cosDocument);
            this.watchdog.start();
        }
        catch (RuntimeException e) {
            Log.warn("Couldn't initialize XMP structure", (Throwable)e);
        }
    }

    protected XMPMetadata createNewXMPMetadata() throws IOException {
        return new XMPMetadataPDFA();
    }

    protected XMPMetadata createXMPMetadata() throws IOException {
        byte[] metadata = this.getMetadata();
        if (metadata != null) {
            XMPMetadata xMPMetadata;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(metadata);
            try {
                xMPMetadata = this.parseXMPMetadata(inputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    Log.warn("Couldn't parse XMP metadata", (Throwable)exception);
                }
            }
            ((InputStream)inputStream).close();
            return xMPMetadata;
        }
        return this.createNewXMPMetadata();
    }

    protected XMPSchemaBasic getBasicSchema() throws IOException {
        XMPSchemaBasic basic = this.getXMPMetadata().getBasicSchema();
        if (basic == null) {
            basic = this.getXMPMetadata().addBasicSchema();
        }
        return basic;
    }

    public COSDocument getCosDoc() {
        return this.cosDocument;
    }

    protected XMPSchemaDublinCore getDublinCoreSchema() throws IOException {
        XMPSchemaDublinCore dublinCore = this.getXMPMetadata().getDublinCoreSchema();
        if (dublinCore == null) {
            dublinCore = this.getXMPMetadata().addDublinCoreSchema();
        }
        return dublinCore;
    }

    public byte[] getMetadata() {
        COSCatalog catalog = this.cosDocument.getCatalog();
        COSStream stream = catalog.cosGetField(COSCatalog.DK_Metadata).asStream();
        if (stream == null) {
            return null;
        }
        return stream.getDecodedBytes();
    }

    protected XMPSchemaPDF getPDFSchema() throws IOException {
        XMPSchemaPDF pdf = this.getXMPMetadata().getPDFSchema();
        if (pdf == null) {
            pdf = this.getXMPMetadata().addPDFSchema();
        }
        return pdf;
    }

    public XMPMetadata getXMPMetadata() {
        if (this.xmpMetadata == null) {
            try {
                this.xmpMetadata = this.createXMPMetadata();
            }
            catch (IOException exception) {
                Log.warn("Couldn't initialize XMP metadata", (Throwable)exception);
            }
        }
        return this.xmpMetadata;
    }

    public XMPMetadataPDFA getXMPMetadataAsPDFA() {
        if (this.getXMPMetadata() instanceof XMPMetadataPDFA) {
            return (XMPMetadataPDFA)this.getXMPMetadata();
        }
        return null;
    }

    public boolean isDefined() {
        return this.getMetadata() != null;
    }

    protected XMPMetadata parseXMPMetadata(InputStream inputStream) throws IOException {
        return XMPMetadataPDFA.load((InputStream)inputStream);
    }

    public void persist() throws XMPStructureException {
        XMPMetadata xmpMetadata = this.getXMPMetadata();
        if (xmpMetadata == null) {
            return;
        }
        this.persisting = true;
        try {
            this.setMetadata(xmpMetadata.asByteArray());
        }
        catch (Exception exception) {
            throw new XMPStructureException("Failed to serialize XMP metadata", exception);
        }
        finally {
            this.persisting = false;
        }
    }

    public void setMetadata(byte[] metadata) {
        COSCatalog catalog = this.cosDocument.getCatalog();
        if (metadata == null) {
            catalog.cosRemoveField(COSCatalog.DK_Metadata);
        } else {
            COSStream stream = COSStream.create(null);
            stream.getDict().put(PDObject.DK_Type, (COSObject)CN_Metadata);
            stream.getDict().put(PDObject.DK_Subtype, (COSObject)CN_XML);
            stream.setDecodedBytes(metadata);
            catalog.cosSetField(COSCatalog.DK_Metadata, (COSObject)stream);
        }
    }

    private Calendar toCalendar(CDSDate date) {
        if (date == null) {
            return null;
        }
        try {
            return CDSDate.toCalendar((String)date.stringValue());
        }
        catch (ParseException exception) {
            return null;
        }
    }

    public void updateFromInfoDict() {
        this.updateFromInfoDict(null);
    }

    private void updateFromInfoDict(Object key) {
        if (this.getXMPMetadata() == null) {
            return;
        }
        COSInfoDict infoDict = this.cosDocument.getInfoDict();
        if (infoDict == null) {
            return;
        }
        try {
            XMPSchemaDublinCore dublinCore;
            List oldCreators;
            String author;
            boolean anythingChanged = false;
            if (key == null || COSInfoDict.DK_Title.equals(key)) {
                anythingChanged |= this.updateIfNecessary(infoDict.getTitle(), () -> this.getDublinCoreSchema().getTitle("x-default"), title -> this.getDublinCoreSchema().setTitle("x-default", title));
            }
            if (!(key != null && !COSInfoDict.DK_Author.equals(key) || (author = infoDict.getAuthor()) == null || (oldCreators = (dublinCore = this.getDublinCoreSchema()).getCreators()) != null && oldCreators.size() == 1 && oldCreators.contains(author))) {
                if (oldCreators != null) {
                    for (String oldCreator : oldCreators) {
                        dublinCore.removeCreator(oldCreator);
                    }
                }
                dublinCore.addCreator(author);
                anythingChanged = true;
            }
            if (key == null || COSInfoDict.DK_Subject.equals(key)) {
                anythingChanged |= this.updateIfNecessary(infoDict.getSubject(), () -> this.getDublinCoreSchema().getDescription("x-default"), description -> this.getDublinCoreSchema().setDescription("x-default", description));
            }
            if (key == null || COSInfoDict.DK_Keywords.equals(key)) {
                anythingChanged |= this.updateIfNecessary(infoDict.getKeywords(), () -> this.getPDFSchema().getKeywords(), keywords -> this.getPDFSchema().setKeywords(keywords));
            }
            if (key == null || COSInfoDict.DK_Creator.equals(key)) {
                anythingChanged |= this.updateIfNecessary(infoDict.getCreator(), () -> this.getBasicSchema().getCreatorTool(), creator -> this.getBasicSchema().setCreatorTool(creator));
            }
            if (key == null || COSInfoDict.DK_Producer.equals(key)) {
                anythingChanged |= this.updateIfNecessary(infoDict.getProducer(), () -> this.getPDFSchema().getProducer(), producer -> this.getPDFSchema().setProducer(producer));
            }
            if (key == null || COSInfoDict.DK_CreationDate.equals(key)) {
                anythingChanged |= this.updateIfNecessary(this.toCalendar(infoDict.getCreationDate()), () -> this.getBasicSchema().getCreateDate(), date -> this.getBasicSchema().setCreateDate(date));
            }
            if (key == null || COSInfoDict.DK_ModDate.equals(key)) {
                anythingChanged |= this.updateIfNecessary(this.toCalendar(infoDict.getModDate()), () -> this.getBasicSchema().getModifyDate(), date -> this.getBasicSchema().setModifyDate(date));
            }
            if (anythingChanged && this.isDefined()) {
                this.persist();
            }
        }
        catch (XMPStructureException | IOException exception) {
            Log.warn("Failed to update XMP metadata from document information dictionary", (Throwable)exception);
        }
    }

    private <T extends Comparable<T>> boolean updateIfNecessary(T expected, Getter<T> getter, Setter<T> setter) throws IOException {
        if (expected == null) {
            return false;
        }
        try {
            Comparable actual = (Comparable)getter.get();
            if (actual != null && actual.compareTo(expected) == 0) {
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        setter.set(expected);
        return true;
    }

    private class XMPWatchdog
    extends COSStructureWatchdog {
        public XMPWatchdog(COSDocument cosDocument) {
            ICOSObjectListener metadataListener = (object, slot, oldValue, newValue) -> {
                if (!XMPStructure.this.persisting) {
                    XMPStructure.this.xmpMetadata = null;
                }
            };
            COSAspectWatchdog catalogWatchdog = this.watch(COSTrailer.DK_Root, metadataListener);
            COSAspectWatchdog metadataWatchdog = catalogWatchdog.watch((Object)COSCatalog.DK_Metadata, metadataListener);
            metadataWatchdog.watch(COSStream.SLOT_BYTES, metadataListener);
            COSAspectWatchdog infoDictWatchdog = this.watch(COSTrailer.DK_Info, (object, slot, oldValue, newValue) -> XMPStructure.this.updateFromInfoDict());
            infoDictWatchdog.watch(null, (object, slot, oldValue, newValue) -> XMPStructure.this.updateFromInfoDict(slot));
            this.setWatched(cosDocument);
        }
    }

    private static interface Getter<T> {
        public T get() throws IOException;
    }

    private static interface Setter<T> {
        public void set(T var1) throws IOException;
    }
}

